package com.bxm.mccms.facade.service;

import java.util.List;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.bxm.mccms.facade.constant.Constants;

/**
 * <p>
 * 审核 feign client 服务
 * </p>
 *
 * @author zhengwangeng
 * @since 2021-7-22
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface IAuditFacadeService {

    /**
     * 广告位终审通过
     * @param ids 广告位ID
     * @return
     */
    @RequestMapping(value = "/facade/audit/position/pass", method = RequestMethod.GET, consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Boolean> auditPositionPass(@RequestParam(value = "ids") List<Long> ids);

    /**
     * 应用终审通过
     * @param appId 应用ID
     * @return
     */
    @RequestMapping(value = "/facade/audit/app/pass", method = RequestMethod.GET, consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Boolean> auditAppPass(@RequestParam(value = "appId") Long appId);
}
