/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mcssp.common.util;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.lang3.StringUtils;

public class EmailSender {
    private static Map<String, Session> sessionMap = new HashMap<String, Session>();
    private Session session;
    private Boolean cacheSession = Boolean.TRUE;
    private Properties props;
    private MimeMessage mimeMessage;
    private Email email;

    private EmailSender(Boolean cacheSession, Email email) {
        if (null != cacheSession) {
            this.cacheSession = cacheSession;
        }
        this.email = email;
        this.init();
    }

    private EmailSender(Boolean cacheSession, String host, String username, String password) {
        if (null != cacheSession) {
            this.cacheSession = cacheSession;
        }
        this.email = new Email();
        this.email.setAccount(new SenderAccount(host, username, password));
        this.init();
    }

    private EmailSender(Boolean cacheSession, String host, String username, String password, Integer port, Boolean ssl, String encoding) {
        if (null != cacheSession) {
            this.cacheSession = cacheSession;
        }
        this.email = new Email();
        this.email.setAccount(new SenderAccount(host, username, password, port, ssl, encoding));
        this.init();
    }

    private void init() {
        this.session = Boolean.TRUE.equals(this.cacheSession) ? this.getCacheSession() : this.getNewSession();
        this.mimeMessage = new MimeMessage(this.session);
    }

    private Session getCacheSession() {
        String key = this.email.getAccount().getHost();
        Session session = sessionMap.get(key);
        if (session == null) {
            session = this.getNewSession();
            sessionMap.put(key, session);
        }
        return session;
    }

    private Session getNewSession() {
        if (this.props == null) {
            this.props = System.getProperties();
        }
        SenderAccount account = this.email.getAccount();
        this.props.put("mail.smtp.host", account.getHost());
        this.props.put("mail.smtp.port", account.getPort());
        this.props.put("mail.smtp.socketFactory.port", account.getPort());
        if (Boolean.TRUE.equals(account.getSsl())) {
            this.props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        }
        this.props.put("mail.smtp.auth", "false");
        this.props.put("mail.debug", "false");
        return Session.getInstance((Properties)this.props);
    }

    public static EmailSender create(Boolean cacheSession, Email email) throws MessagingException {
        return new EmailSender(cacheSession, email);
    }

    public static EmailSender create(String host, String username, String password, Integer port) throws MessagingException {
        return new EmailSender(Boolean.TRUE, host, username, password, port, null, null);
    }

    public static EmailSender create(String host, String username, String password, Integer port, Boolean cacheSession) throws MessagingException {
        return new EmailSender(cacheSession, host, username, password, port, null, null);
    }

    public static EmailSender create(String host, String username, String password, Integer port, Boolean ssl, Boolean cacheSession) throws MessagingException {
        return new EmailSender(cacheSession, host, username, password, port, ssl, null);
    }

    public static EmailSender create(String host, String username, String password, Integer port, Boolean ssl, String encoding, Boolean cacheSession) throws MessagingException {
        return new EmailSender(cacheSession, host, username, password, port, ssl, encoding);
    }

    public EmailSender setFrom(String from) throws MessagingException {
        this.email.setFrom(from);
        return this;
    }

    public EmailSender setToList(List<String> toList) {
        this.email.setToList(toList);
        return this;
    }

    public EmailSender setCcList(List<String> ccList) {
        this.email.setCcList(ccList);
        return this;
    }

    public EmailSender setBccList(List<String> bccList) {
        this.email.setBccList(bccList);
        return this;
    }

    public EmailSender setSubject(String subject) {
        this.email.setSubject(subject);
        return this;
    }

    public EmailSender setText(String text) {
        this.email.setContent(text);
        this.email.setType(1);
        return this;
    }

    public EmailSender setHtml(String html, String charset) {
        this.email.setContent(html);
        this.email.setType(2);
        if (charset == null) {
            this.email.setCharset("UTF-8");
        } else {
            this.email.setCharset(charset);
        }
        return this;
    }

    public EmailSender setImageMap(Map<String, String> imageMap) {
        this.email.setImageMap(imageMap);
        return this;
    }

    public EmailSender setAttachmentList(List<String> attachmentList) {
        this.email.setAttachmentList(attachmentList);
        return this;
    }

    public EmailSender addTo(String to) {
        if (this.email.getToList() == null) {
            this.email.setToList(new ArrayList<String>());
        }
        this.email.getToList().add(to);
        return this;
    }

    public EmailSender addCc(String cc) {
        if (this.email.getCcList() == null) {
            this.email.setCcList(new ArrayList<String>());
        }
        this.email.getCcList().add(cc);
        return this;
    }

    public EmailSender addBcc(String bcc) {
        if (this.email.getBccList() == null) {
            this.email.setBccList(new ArrayList<String>());
        }
        this.email.getBccList().add(bcc);
        return this;
    }

    public EmailSender addImage(String cid, String image) {
        if (this.email.getImageMap() == null) {
            this.email.setImageMap(new HashMap<String, String>());
        }
        this.email.getImageMap().put(cid, image);
        return this;
    }

    public EmailSender addAttachment(String attachment) {
        if (this.email.getAttachmentList() == null) {
            this.email.setAttachmentList(new ArrayList<String>());
        }
        this.email.getAttachmentList().add(attachment);
        return this;
    }

    public boolean send() throws Exception {
        this.prepare();
        SenderAccount account = this.email.getAccount();
        Transport transport = this.session.getTransport("smtp");
        transport.connect(account.getHost(), account.getUsername(), account.getPassword());
        transport.sendMessage((Message)this.mimeMessage, this.mimeMessage.getAllRecipients());
        transport.close();
        return Boolean.TRUE;
    }

    private void prepare() throws MessagingException, UnsupportedEncodingException {
        List<String> attachmentList;
        SenderAccount account = this.email.getAccount();
        MimeMultipart multipart = new MimeMultipart();
        this.mimeMessage.setContent((Multipart)multipart);
        this.mimeMessage.setFrom((Address)new InternetAddress(account.getUsername(), this.encode(this.email.getFrom())));
        if (CollectionUtils.isNotEmpty(this.email.getToList())) {
            String to = StringUtils.join(this.email.getToList(), (String)",");
            this.mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to));
        }
        if (CollectionUtils.isNotEmpty(this.email.getCcList())) {
            String cc = StringUtils.join(this.email.getCcList(), (String)",");
            this.mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)cc));
        }
        if (CollectionUtils.isNotEmpty(this.email.getBccList())) {
            String bcc = StringUtils.join(this.email.getBccList(), (String)",");
            this.mimeMessage.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)bcc));
        }
        this.mimeMessage.setSubject(this.email.getSubject());
        MimeBodyPart bodyPart = new MimeBodyPart();
        if (2 == this.email.getType()) {
            String charset = this.email.charset == null ? "UTF-8" : this.email.charset;
            String content = StringUtils.join((Object[])new String[]{"<meta http-equiv=Content-Type content=text/html;charset=", charset, ">", this.email.getContent()});
            bodyPart.setContent((Object)content, StringUtils.join((Object[])new String[]{"text/html;charset=", charset}));
        } else {
            bodyPart.setText(this.email.getContent());
        }
        multipart.addBodyPart((BodyPart)bodyPart);
        Map<String, String> imageMap = this.email.getImageMap();
        if (MapUtils.isNotEmpty(imageMap)) {
            Set<String> keySet = imageMap.keySet();
            for (String cid : keySet) {
                String image = imageMap.get(cid);
                bodyPart = new MimeBodyPart();
                DataHandler dh = new DataHandler((DataSource)new FileDataSource(image));
                bodyPart.setDataHandler(dh);
                bodyPart.setContentID(cid);
                multipart.addBodyPart((BodyPart)bodyPart);
            }
        }
        if (CollectionUtils.isNotEmpty(attachmentList = this.email.getAttachmentList())) {
            for (String attachment : attachmentList) {
                bodyPart = new MimeBodyPart();
                DataHandler dh = new DataHandler((DataSource)new FileDataSource(attachment));
                bodyPart.setDataHandler(dh);
                bodyPart.setFileName(this.encode(dh.getName()));
                multipart.addBodyPart((BodyPart)bodyPart);
            }
        }
    }

    private String encode(String source) throws UnsupportedEncodingException {
        return MimeUtility.encodeText((String)source);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this.email, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static class SenderAccount
    implements Serializable {
        private static final long serialVersionUID = 7953257301233581347L;
        private String host;
        private String username;
        private String password;
        private Integer port = 25;
        private Boolean ssl = Boolean.TRUE;
        private String encoding = "UTF-8";

        public SenderAccount() {
        }

        public SenderAccount(String host, String username, String password) {
            this.host = host;
            this.username = username;
            this.password = password;
        }

        public SenderAccount(String host, String username, String password, Integer port) {
            this.host = host;
            this.username = username;
            this.password = password;
            if (port != null) {
                this.port = port;
            }
        }

        public SenderAccount(String host, String username, String password, Integer port, Boolean ssl) {
            this.host = host;
            this.username = username;
            this.password = password;
            if (port != null) {
                this.port = port;
            }
            if (ssl != null) {
                this.ssl = ssl;
            }
        }

        public SenderAccount(String host, String username, String password, Integer port, Boolean ssl, String encoding) {
            this.host = host;
            this.username = username;
            this.password = password;
            if (port != null) {
                this.port = port;
            }
            if (ssl != null) {
                this.ssl = ssl;
            }
            if (encoding != null) {
                this.encoding = encoding;
            }
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public Integer getPort() {
            return this.port;
        }

        public void setPort(Integer port) {
            this.port = port;
        }

        public Boolean getSsl() {
            return this.ssl;
        }

        public void setSsl(Boolean ssl) {
            this.ssl = ssl;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }
    }

    public static class Email
    implements Serializable {
        private static final long serialVersionUID = 7953257301233581347L;
        private SenderAccount account;
        private String from;
        private String subject;
        private String content;
        private Integer type = 1;
        private String charset;
        private List<String> toList;
        private List<String> ccList;
        private List<String> bccList;
        private Map<String, String> imageMap;
        private List<String> attachmentList;

        public Email() {
        }

        public Email(SenderAccount account, String from, String subject, String content, String to) {
            this.account = account;
            this.from = from;
            this.subject = subject;
            this.content = content;
            this.toList = new ArrayList<String>(Arrays.asList(to));
        }

        public Email(SenderAccount account, String from, String subject, String content, List<String> toList) {
            this.account = account;
            this.from = from;
            this.subject = subject;
            this.content = content;
            this.toList = toList;
        }

        public Email(String from, String subject, String content, String to) {
            this.from = from;
            this.subject = subject;
            this.content = content;
            this.toList = new ArrayList<String>(Arrays.asList(to));
        }

        public Email(String from, String subject, String content, List<String> toList) {
            this.from = from;
            this.subject = subject;
            this.content = content;
            this.toList = toList;
        }

        public SenderAccount getAccount() {
            return this.account;
        }

        public void setAccount(SenderAccount account) {
            this.account = account;
        }

        public String getFrom() {
            return this.from;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public String getSubject() {
            return this.subject;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public List<String> getToList() {
            return this.toList;
        }

        public Integer getType() {
            return this.type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public String getCharset() {
            return this.charset;
        }

        public void setCharset(String charset) {
            this.charset = charset;
        }

        public void setToList(List<String> toList) {
            this.toList = toList;
        }

        public List<String> getCcList() {
            return this.ccList;
        }

        public void setCcList(List<String> ccList) {
            this.ccList = ccList;
        }

        public List<String> getBccList() {
            return this.bccList;
        }

        public void setBccList(List<String> bccList) {
            this.bccList = bccList;
        }

        public Map<String, String> getImageMap() {
            return this.imageMap;
        }

        public void setImageMap(Map<String, String> imageMap) {
            this.imageMap = imageMap;
        }

        public List<String> getAttachmentList() {
            return this.attachmentList;
        }

        public void setAttachmentList(List<String> attachmentList) {
            this.attachmentList = attachmentList;
        }
    }
}

