/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mcssp.common.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class RegExpValidatorUtils {
    public static boolean isEmail(String str) {
        String regex = "^([\\w-\\.]+)@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.)|(([\\w-]+\\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\\]?)$";
        return RegExpValidatorUtils.match(regex, str);
    }

    public static boolean isIP(String str) {
        String num = "(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)";
        String regex = "^" + num + "\\." + num + "\\." + num + "\\." + num + "$";
        return RegExpValidatorUtils.match(regex, str);
    }

    public static boolean isUrl(String str) {
        String regex = "http(s)?://([\\w-]+\\.)+[\\w-]+(/[\\w- ./?%&=]*)?";
        return RegExpValidatorUtils.match(regex, str);
    }

    public static boolean isTelephone(String str) {
        String regex = "^(\\d{3,4}-)?\\d{6,8}$";
        return RegExpValidatorUtils.match(regex, str);
    }

    public static boolean isPassword(String str) {
        String regex = "^(\\w){6,16}$";
        return RegExpValidatorUtils.match(regex, str);
    }

    public static boolean isPasswLength(String str) {
        String regex = "^\\d{6,18}$";
        return RegExpValidatorUtils.match(regex, str);
    }

    public static boolean isPostalcode(String str) {
        String regex = "^\\d{6}$";
        return RegExpValidatorUtils.match(regex, str);
    }

    public static boolean isMobileNO(String str) {
        String regex = "^(0|86|17951)?(13[0-9]|15[012356789]|17[0135678]|18[0-9]|19[0-9]|14[579])[0-9]{8}$";
        return RegExpValidatorUtils.match(regex, str);
    }

    public static boolean isIDcard(String str) {
        String regex = "(^\\d{15}$)|(^\\d{18}$)|(^\\d{17}(\\d|X|x)$)";
        return RegExpValidatorUtils.match(regex, str);
    }

    public static boolean isTowSmallDigitDecimal(String str) {
        String regex = "^[0-9]+(.[0-9]{2})?$";
        return RegExpValidatorUtils.match(regex, str);
    }

    public static boolean limitDecimalFormat(String str, int decimalLength, int smallDigit) {
        String regex = "^[0-9]{1," + decimalLength + "}(.[0-9]{0," + smallDigit + "})?$";
        return RegExpValidatorUtils.match(regex, str);
    }

    public static boolean betweenZeroAndOne(String str, int smallDigit) {
        String regex = "^?(0\\.\\d*[0-9]{0," + smallDigit + "})$";
        return RegExpValidatorUtils.match(regex, str);
    }

    public static boolean isMonth(String str) {
        String regex = "^(0?[[1-9]|1[0-2])$";
        return RegExpValidatorUtils.match(regex, str);
    }

    public static boolean isDay(String str) {
        String regex = "^((0?[1-9])|((1|2)[0-9])|30|31)$";
        return RegExpValidatorUtils.match(regex, str);
    }

    public static boolean isDate(String str) {
        String regex = "^((((1[6-9]|[2-9]\\d)\\d{2})-(0?[13578]|1[02])-(0?[1-9]|[12]\\d|3[01]))|(((1[6-9]|[2-9]\\d)\\d{2})-(0?[13456789]|1[012])-(0?[1-9]|[12]\\d|30))|(((1[6-9]|[2-9]\\d)\\d{2})-0?2-(0?[1-9]|1\\d|2[0-8]))|(((1[6-9]|[2-9]\\d)(0[48]|[2468][048]|[13579][26])|((16|[2468][048]|[3579][26])00))-0?2-29-)) (20|21|22|23|[0-1]?\\d):[0-5]?\\d:[0-5]?\\d$";
        return RegExpValidatorUtils.match(regex, str);
    }

    public static boolean isNumber(String str) {
        String regex = "^[0-9]*$";
        return RegExpValidatorUtils.match(regex, str);
    }

    public static boolean isIntNumber(String str) {
        String regex = "^\\+?[1-9][0-9]*$";
        return RegExpValidatorUtils.match(regex, str);
    }

    public static boolean isUpChar(String str) {
        String regex = "^[A-Z]+$";
        return RegExpValidatorUtils.match(regex, str);
    }

    public static boolean isLowChar(String str) {
        String regex = "^[a-z]+$";
        return RegExpValidatorUtils.match(regex, str);
    }

    public static boolean isLetter(String str) {
        String regex = "^[A-Za-z]+$";
        return RegExpValidatorUtils.match(regex, str);
    }

    public static boolean isChinese(String str) {
        String regex = "^[\u4e00-\u9fa5],{0,}$";
        return RegExpValidatorUtils.match(regex, str);
    }

    private static boolean match(String regex, String str) {
        if (StringUtils.isBlank((CharSequence)regex) || StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(str);
        return matcher.matches();
    }
}

