/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mcssp.common.util;

import com.tinify.Tinify;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;

public class ImageUtil {
    private static final String LEFT_TOP = "left_top";
    private static final String RIGHT_TOP = "right_top";
    private static final String LEFT_BOTTOM = "left_bottom";
    private static final String RIGHT_BOTTOM = "right_bottom";

    public static void compressedImageByWidthAndHeight(String srcImgPath, String compressedImgPath, int width, int height) throws IOException {
        File srcFile = new File(srcImgPath);
        BufferedImage srcImg = ImageIO.read(srcFile);
        BufferedImage buffImg = null;
        buffImg = new BufferedImage(width, height, 1);
        buffImg.getGraphics().drawImage(srcImg.getScaledInstance(width, height, 4), 0, 0, null);
        ImageIO.write((RenderedImage)buffImg, "JPEG", new File(compressedImgPath));
    }

    public static final void pressImage(String pressImg, String targetImg, String loaction, Integer degree) {
        try {
            File _file = new File(targetImg);
            BufferedImage src = ImageIO.read(_file);
            int wideth = ((Image)src).getWidth(null);
            int height = ((Image)src).getHeight(null);
            BufferedImage image = new BufferedImage(wideth, height, 1);
            Graphics2D g = image.createGraphics();
            g.drawImage(src, 0, 0, wideth, height, null);
            File _filebiao = new File(pressImg);
            BufferedImage src_biao = ImageIO.read(_filebiao);
            int wideth_biao = ((Image)src_biao).getWidth(null);
            int height_biao = ((Image)src_biao).getHeight(null);
            int x = 0;
            int y = 0;
            if (StringUtils.equals((CharSequence)loaction, (CharSequence)LEFT_TOP)) {
                g.drawImage(src_biao, x, y, wideth_biao, height_biao, null);
            } else if (StringUtils.equals((CharSequence)loaction, (CharSequence)RIGHT_TOP)) {
                x = wideth - wideth_biao;
            } else if (StringUtils.equals((CharSequence)loaction, (CharSequence)LEFT_BOTTOM)) {
                y = height - height_biao;
            } else if (StringUtils.equals((CharSequence)loaction, (CharSequence)RIGHT_BOTTOM)) {
                x = wideth - wideth_biao;
                y = height - height_biao;
            } else {
                x = (wideth - wideth_biao) / 2;
                y = (height - height_biao) / 2;
            }
            if (null != degree) {
                g.rotate(Math.toRadians(degree.intValue()), x, y);
            }
            g.drawImage(src_biao, x, y, wideth_biao, height_biao, null);
            g.dispose();
            String formatName = targetImg.substring(targetImg.lastIndexOf(".") + 1);
            ImageIO.write((RenderedImage)image, formatName, new File(targetImg));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void pressText(String pressText, String targetImg, String fontName, int fontStyle, int color, int fontSize, int x, int y) {
        try {
            File _file = new File(targetImg);
            BufferedImage src = ImageIO.read(_file);
            int wideth = ((Image)src).getWidth(null);
            int height = ((Image)src).getHeight(null);
            BufferedImage image = new BufferedImage(wideth, height, 1);
            Graphics2D g = image.createGraphics();
            g.drawImage(src, 0, 0, wideth, height, null);
            g.setColor(Color.RED);
            g.setFont(new Font(fontName, fontStyle, fontSize));
            ((Graphics)g).drawString(pressText, wideth - fontSize - x, height - fontSize / 2 - y);
            g.dispose();
            String formatName = targetImg.substring(targetImg.lastIndexOf(".") + 1);
            ImageIO.write((RenderedImage)image, formatName, new File(targetImg));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static byte[] compressionFromUrl(String apiKey, String url) throws IOException {
        Tinify.setKey((String)apiKey);
        return Tinify.fromUrl((String)url).toBuffer();
    }

    public static byte[] compressionFromBuffer(String apiKey, byte[] buffer) throws IOException {
        Tinify.setKey((String)apiKey);
        return Tinify.fromBuffer((byte[])buffer).toBuffer();
    }

    public static byte[] compressionFromFile(String apiKey, String path) throws IOException {
        Tinify.setKey((String)apiKey);
        return Tinify.fromFile((String)path).toBuffer();
    }
}

