package com.bxm.mcssp.common.context.user;

import com.bxm.mcssp.common.entity.User;
import com.bxm.mcssp.common.exception.AuthException;

import lombok.extern.slf4j.Slf4j;

/**
 * <p>
 * 当前登录人信息的全局变量
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-18
 */
@Slf4j
public class UserSessionContext {

    private final static ThreadLocal<User> CONTEXT = new ThreadLocal<>();

    public static void setContext(User user) {
        CONTEXT.set(user);
    }

    public static void remove() {
        CONTEXT.remove();
    }

    public static User get() {
        return CONTEXT.get();
    }

    private static User getCurrentUser() {
        User user = CONTEXT.get();
        if (null == user) {
            log.warn("检查下权限 --> ");
            throw new AuthException();
        }
        return user;
    }

    /**
     * 获取当前登录人ID
     *
     * @return
     */
    public static Long getDeveloperId() {
        return getCurrentUser().getId();
    }

    /**
     * 获取当前登录人的客户开发者ID
     *
     * @return
     */
    public static String getCustomDeveloperId() {
        return getCurrentUser().getCustomDevId();
    }

    /**
     * 获取当前登录是否是模拟登陆
     *
     * @return
     */
    public static Boolean getIsSimulationLogin() {
        return getCurrentUser().getIsSimulationLogin();
    }

    /**
     * 获取当前登录用户的手机号码
     *
     * @return
     */
    public static String getPhoneNum() {
        return getCurrentUser().getPhoneNum();
    }

    /**
     * 获取当前会话token
     *
     * @return
     */
    public static String getToken() {
        return getCurrentUser().getToken();
    }

    /**
     * 获取开发者名称 （等于之前的APP_NAME名称）
     *
     * @return
     */
    public static String getDeveloperName() {
        return getCurrentUser().getDeveloperName();
    }

    /**
     * 是否已登录
     *
     * @return
     */
    public static Boolean hasLogged() {
        return null != get();
    }

    /**
     * 获取appkey
     *
     * @return
     */
    public static String getAppKey() {
        return getCurrentUser().getAppKey();
    }
}
