package com.bxm.mcssp.common.enums.app;

/**
 * <p>
 * 平台类型：1 IOS，2 安卓，3 H5，4 PC
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-17
 */
public enum AppPlatformTypeEnum {

    /**
     * IOS
     */
    IOS( 1, "IOS"),

    /**
     * 安卓
     */
    ANDROID(2, "安卓"),

    /**
     * H5
     */
    H5( 3, "H5"),

    /**
     * PC
     */
    PC(4, "PC");

    private Integer type;

    private String desc;

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    AppPlatformTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static AppPlatformTypeEnum get(Integer type) {
        if (null == type) {
            return null;
        }
        for (AppPlatformTypeEnum anEnum : values()) {
            if (anEnum.getType().equals(type)) {
                return anEnum;
            }
        }
        return null;
    }

}
