package com.bxm.mcssp.common.enums.position;

/**
 * <p>
 * 支持的广告位类型：1 落地页，2 下载类，3 Deeplink类
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-17
 */
public enum PositionSupportTypeEnum {

    /**
     * 落地页
     */
    URL(1, "落地页"),

    /**
     * 下载类
     */
    DOWNLOAD(2, "下载类"),

    /**
     * Deeplink类
     */
    DEEPLINK(3, "Deeplink类");

    private Integer type;

    private String name;

    public Integer getType() {
        return type;
    }

    public String getName() {
        return name;
    }

    PositionSupportTypeEnum(Integer type, String name) {
        this.type = type;
        this.name = name;
    }

    public static PositionSupportTypeEnum get(Integer type) {
        if (null == type) {
            return null;
        }
        for (PositionSupportTypeEnum anEnum : values()) {
            if (anEnum.getType().equals(type)) {
                return anEnum;
            }
        }
        return null;
    }

}
