package com.bxm.mcssp.common.enums.position;

/**
 * <p>
 * 广告位类型：1 图文，2 图片，3 文字，4 视频
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-17
 */
public enum PositionTypeEnum {

    /**
     * 图文
     */
    VIDEOTEX(1, "图文"),

    /**
     * 图片
     */
    PICTURE(2, "图片"),

    /**
     * 文字
     */
    TEXT(3, "文字"),

    /**
     * 视频
     */
    VIDEO(4, "视频");

    private Integer type;

    private String name;

    public Integer getType() {
        return type;
    }

    public String getName() {
        return name;
    }

    PositionTypeEnum(Integer type, String name) {
        this.type = type;
        this.name = name;
    }

    public static PositionTypeEnum get(Integer type) {
        if (null == type) {
            return null;
        }
        for (PositionTypeEnum anEnum : values()) {
            if (anEnum.getType().equals(type)) {
                return anEnum;
            }
        }
        return null;
    }

}
