package com.bxm.mcssp.common.context.user;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import com.bxm.mcssp.common.entity.RequestInfo;

/**
 * <p>
 * 当前登录用户请求上下文
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-18
 */
public class RequestInfoContext {

    private final static ThreadLocal<RequestInfo> CONTEXT = new ThreadLocal<>();

    public static void setContext(RequestInfo requestInfo) {
        CONTEXT.set(requestInfo);
    }

    public static void remove() {
        CONTEXT.remove();
    }

    public static RequestInfo get() {
        return CONTEXT.get();
    }

    public static HttpServletResponse getResponse() {
        return CONTEXT.get().getResponse();
    }

    public static HttpServletRequest getRequest() {
        return CONTEXT.get().getRequest();
    }

    public static HttpSession getSession() {
        return CONTEXT.get().getRequest().getSession();
    }

}
