package com.bxm.mcssp.common.entity;

import java.io.Serializable;

import lombok.Data;

/**
 * <p>
 * ID和名称的通用结果对象
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-24
 */
@Data
public class IDAndNameVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 真实ID，如appId,positionId
     */
    private String realId;

    /**
     * 名称
     */
    private String name;

    /**
     * 平台类型：1 IOS，2 安卓，3 H5，4 PC
     */
    private Integer platformType;

    /**
     * 审核状态：0 风控终审，1 终审通过，2 终审拒绝，3 媒介初审，4 初审拒绝
     */
    private Integer status;
}
