package com.bxm.mcssp.common.enums.developer;

/**
 * Description 开发者类型
 *
 * <p>
 * Date 2019/1/15 15:35
 */
public enum ProviderTypeEnum {

    /**
     * 直客
     */
    DIRECT_CUSTOMER((byte) 0, "直客"),

    /**
     * 代理
     */
    PROXY_CUSTOMER((byte) 1, "代理");


    private Byte code;

    private String desc;

    public Byte getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    ProviderTypeEnum(Byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ProviderTypeEnum getByCode(Byte code) {
        if (null == code) {
            return null;
        }
        for (ProviderTypeEnum anEnum : values()) {
            if (anEnum.getCode().equals(code)) {
                return anEnum;
            }
        }
        return null;
    }

}
