package com.bxm.mcssp.common.enums.position;

/**
 * <p>
 * 广告位类型（这个是客户化类型）：1 标准广告，2 非标准广告，3 聚合广告
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-8-25
 */
public enum CustomPositionTypeEnum {

    /**
     * 标准广告位
     */
    STANDARD(1, "标准广告"),

    /**
     * 非标准广告位
     */
    NON_STANDARD(2, "非标广告"),

    /**
     * 聚合广告位
     */
    COLLECTION(3, "聚合广告"),

    /**
     * 其它，这里用于标识已删除的广告位场景类型：搜索，特殊，自渲染信息流
     */
    OTHER(-1, "其它"),
    ;

    private Integer type;

    private String name;

    public Integer getType() {
        return type;
    }

    public String getName() {
        return name;
    }

    CustomPositionTypeEnum(Integer type, String name) {
        this.type = type;
        this.name = name;
    }

    public static CustomPositionTypeEnum get(Integer type) {
        if (null == type) {
            return null;
        }
        for (CustomPositionTypeEnum anEnum : values()) {
            if (anEnum.getType().equals(type)) {
                return anEnum;
            }
        }
        return null;
    }

}
