package com.bxm.mcssp.common.enums.position;

/**
 * <p>
 * 合作类型： 1 分成，2 竞价，3 包段，4 UV
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-17
 */
public enum PositionCooperationTypeEnum {

    /**
     * 分成
     */
    DIVIDE_INTO(1, "分成"),

    /**
     * 竞价 | 定价，现在只有cpm的定价
     */
    RTB(2, "竞价"),

    /**
     * 包段 | 合约
     */
    TREATY(3, "合约"),

    /**
     * UV定价
     */
    UV(4, "UV定价"),
    ;

    private Integer type;

    private String name;

    public Integer getType() {
        return type;
    }

    public String getName() {
        return name;
    }

    PositionCooperationTypeEnum(Integer type, String name) {
        this.type = type;
        this.name = name;
    }

    public static PositionCooperationTypeEnum get(Integer type) {
        if (null == type) {
            return null;
        }
        for (PositionCooperationTypeEnum anEnum : values()) {
            if (anEnum.getType().equals(type)) {
                return anEnum;
            }
        }
        return null;
    }

}
