package com.bxm.mcssp.common.enums.position;

/**
 * dcloud枚举 <br/>
 *
 * @author zhengwangeng
 * @since 2021-4-26
 */
public class DcloudEnum {

    /**
     * 分成比例,变现猫和开发者分成
     * 1：10:90
     * 2：40:60
     */
    public enum IncomeRate {

        /** 10:90 */
        ONE(1, "10:90"),

        /** 40:60 */
        TWO(2, "40:60"),
        ;

        /**
         * 值
         */
        private int type;

        /**
         * 描述
         */
        private String desc;

        IncomeRate(int type, String desc) {
            this.type = type;
            this.desc = desc;
        }

        public int getType() {
            return type;
        }

        public String getDesc() {
            return desc;
        }

        public static IncomeRate get(int type) {
            for (IncomeRate temp : IncomeRate.values()) {
                if (temp.type == type) {
                    return temp;
                }
            }
            return null;
        }
    }

    /**
     * 活动类型
     * 1：抽奖
     * 2：游戏
     * 3：养成
     */
    public enum AcitivtyType {

        /** 抽奖 */
        LOTTERY(1, "抽奖"),

        /** 游戏 */
        GAME(2, "游戏"),
        
        /** 养成 */
        DEVELOP(3, "养成"),
        ;

        /**
         * 值
         */
        private int type;

        /**
         * 描述
         */
        private String desc;

        AcitivtyType(int type, String desc) {
            this.type = type;
            this.desc = desc;
        }

        public int getType() {
            return type;
        }

        public String getDesc() {
            return desc;
        }

        public static AcitivtyType get(int type) {
            for (AcitivtyType temp : AcitivtyType.values()) {
                if (temp.type == type) {
                    return temp;
                }
            }
            return null;
        }
    }

    /**
     * 广告商分类
     * 1：穿山甲 2：广点通 3：360 4：dcloud 5：快手
     */
    public enum AdvertiserType {

        /** 穿山甲 */
        GSJ(1, "穿山甲"),

        /** 广点通 */
        GDT(2, "广点通"),

        /** 360 */
        QH(3, "360"),

        /** dcloud */
        DCLOUD(4, "dcloud"),

        /** 快手 */
        KS(5, "快手"),
        ;

        /**
         * 值
         */
        private int type;

        /**
         * 描述
         */
        private String desc;

        AdvertiserType(int type, String desc) {
            this.type = type;
            this.desc = desc;
        }

        public int getType() {
            return type;
        }

        public String getDesc() {
            return desc;
        }

        public static AdvertiserType get(int type) {
            for (AdvertiserType temp : AdvertiserType.values()) {
                if (temp.type == type) {
                    return temp;
                }
            }
            return null;
        }
    }

}
