package com.bxm.mcssp.common.entity;

import java.io.Serializable;

import lombok.Data;

/**
 * <p>
 * 广告位的动态相关配置
 * 由于广告位不同场景的配置差异很大，且有越来越多的情况，所以使用json存储，这里定义json格式
 * </p>
 *
 * @author zhengwangeng
 * @since 2021-01-05
 */
@Data
public class PositionJsonConfig implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * position_scene=PositionSceneTypeEnum.PUSH
     */
    private Push push;

    /**
     * position_scene=PositionSceneTypeEnum.LOCK_SCREEN
     */
    private LockScreen lockScreen;

    /**
     * position_scene=PositionSceneTypeEnum.SCREEN
     */
    private Screen screen;

    /**
     * position_scene=PositionSceneTypeEnum.BOOT
     */
    private Boot boot;
    /**
     * position_scene=PositionSceneTypeEnum.TEXT_LINK
     */
    private TextLink textLink;
    /**
     * position_scene=PositionSceneTypeEnum.InspireVideo
     */
    private InspireVideo inspireVideo;

    @Data
    public static class Common {

        /**
         * 进程名称
         */
        private String processName;

        /**
         * 进程图标
         */
        private String processIcon;

    }

    @Data
    public static class Push extends Common {
        /**
         * 推送模式：0-全局推送 1-app前台推送
         */
        private Integer pushModel;
        /**
         * 请求方式：1-SDK定时请求 2-app主动请求
         */
        private Integer requestModel;
        /**
         * 推送间隔时间，单位为分钟
         * 这个在 广告位 上
         */
        //private Integer pushIntervalTime;

        /**
         * 两次曝光最小间隔:分钟
         */
        private Integer minIntervalBetweenTwoExposures;
        /**
         * 每天每人推送曝光次数上限
         * 如果为null取pushTimesPerPersonPerDay;
         */
        private Integer pushMaxShowPerDay;
    }

    @Data
    public static class LockScreen extends Common {

        /**
         * 广告样式
         * 1:双浮标+资讯/视频  1080*1920px
         * 2:活动+资讯/视频
         */
        private Integer adStyle;

        /**
         * 浮标1广告位ID
         */
        private String iconPositionId1;

        /**
         * 浮标2广告位ID
         */
        private String iconPositionId2;

        /**
         * 资讯/视频URL
         */
        private String url;


        /**
         * 每人每天限出现:次
         */
        private Integer showTimesPerPersonPerDay;

        /**
         * 息屏后延迟触发时间:秒
         */
        private Integer intervalTriggerTime;

        /**
         * 沉默期（单位：小时）
         */
        private Integer silentPeriod;
        /**
         * 用户锁屏设置（0关1开）
         */
        private Integer userLockSetup;
        /**
         * 日历广告位
         */
        private String calendarPositionId;
        /**
         * 天气广告位
         */
        private String weatherPositionId;
        /**
         * 活动广告位
         */
        private String activityPositionId;

    }

    @Data
    public static class Screen {

        /**
         * 每人每天限最大曝光:次
         */
        private Integer exposurePerPersonPerDay;

        /**
         * 两次曝光最小间隔:分钟
         */
        private Integer minIntervalBetweenTwoExposures;

        /**
         * 曝光n秒后可关闭：秒
         */
        private Integer closeAfterSecondsOfExposure;

        /**
         * 加载最大时长：秒
         */
        private Integer maxLoadingTime;
    }

    @Data
    public static class Boot {

        /**
         * 是否优先使用AE的按钮：0为否，1为是
         */
        private Integer firstUsingAeButton;

        /**
         * 开启全屏点击的地域:1-开头为白名单，2-开头为黑名单
         */
        private String region;

        /**
         * 灵敏度值 只有类型为开屏 且广告icon按钮覆盖为否 时有效
         */
        private Integer keenConfig;
    }

    @Data
    public static class TextLink {

        /**
         * 广告标识：0-无/1-有，默认为无
         */
        private Integer adLogo;
    }

    @Data
    public static class InspireVideo {

        /**
         * 灵敏度值
         */
        private Integer keenConfig;
    }
}
