package com.bxm.mcssp.common.enums.app;

/**
 * <p>
 * 对接类型：1 API，2 SDK
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-17
 */
public enum DockingMethodTypeEnum {

    GLOBAL_OPERATION(0, "通用"),

    /**
     * API对接
     */
    API_OPERATION(1, "API对接"),

    /**
     * SDK对接
     */
    SDK_OPERATION(2, "SDK对接"),

    H5_OPERATION(3, "H5对接");

    private Integer type;

    private String desc;

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    DockingMethodTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static DockingMethodTypeEnum get(Integer type) {
        if (null == type) {
            return null;
        }
        for (DockingMethodTypeEnum anEnum : values()) {
            if (anEnum.getType().equals(type)) {
                return anEnum;
            }
        }
        return null;
    }
}
