package com.bxm.mcssp.facade.model.app;

import java.io.Serializable;
import java.time.LocalDateTime;

import com.fasterxml.jackson.annotation.JsonFormat;

import lombok.Data;
import lombok.ToString;

/**
 * <p>
 * 应用
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-18
 */
@Data
@ToString
public class AppFacadeVO extends AppBaseVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 开发者ID
     */
    private Long developerId;

    /**
     * AppID
     */
    private String appId;

    /**
     * 应用名称
     */
    private String appName;

    /**
     * 平台类型：1 IOS，2 安卓，3 H5，4 PC
     */
    private Integer platformType;

    /**
     * 应用分类
     */
    private String appClass;

    /**
     * 应用子分类
     */
    private String appChildClass;

    /**
     * 广告喜好类别，多个类型用逗号分隔
     */
    private String adPreference;

    /**
     * 应用包名
     */
    private String appPackageName;

    /**
     * 应用下载地址
     */
    private String appDownloadUrl;

    /**
     * 审核类型：1 先投后审，2 先审后投
     */
    private Integer auditType;

    /**
     * 对接类型：1 API，2 SDK
     */
    private Integer dockingMethodType;

    /**
     * 应用简介
     */
    private String appDesc;

    /**
     * 审核状态：0 风控终审，1 终审通过，2 终审拒绝，3 媒介初审，4 初审拒绝
     */
    private Integer status;

    /**
     * 审核拒绝配置ID，多个拒绝原因用逗号分隔
     */
    private String reviewRefuseIds;

    /**
     * 拒绝原因
     */
    private String refuseReason;

    /**
     * 广告位数量
     */
    private Integer positionCount;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime createTime;

    /**
     * 修改人
     */
    private String modifyUser;

    /**
     * 修改时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime modifyTime;

    /**
     * 是否逻辑删除：1 表示删除，0 表示未删除
     */
    private Integer deleted;



    //额外的信息
}
