package com.bxm.mcssp.facade.service;

import java.util.List;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.mcssp.facade.constant.Constants;
import com.bxm.mcssp.common.entity.IDAndNameVO;
import com.bxm.mcssp.facade.model.developer.DeveloperFacadeDTO;
import com.bxm.mcssp.facade.model.developer.DeveloperFacadeQueryDTO;
import com.bxm.mcssp.facade.model.developer.DeveloperFacadeVO;

/**
 * <p>
 * 开发者 feign client 服务
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-18
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface DeveloperFacadeService {

    /**
     * ID和名称数据，主要用于下拉框填充
     *
     * @param keyword 查询参数
     * @return
     */
    @RequestMapping(value = "/facade/developer/common/list", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<List<IDAndNameVO>> list(@RequestParam(value = "keyword", required = false) String keyword);

    /**
     * 分页查询
     *
     * @param dto 查询参数
     * @return
     */
    @RequestMapping(value = "/facade/developer/page", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Page<DeveloperFacadeVO>> page(@RequestBody DeveloperFacadeQueryDTO dto);

    /**
     * 根据id查询
     *
     * @param id id
     * @return
     */
    @RequestMapping(value = "/facade/developer/get", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<DeveloperFacadeVO> get(@RequestParam(value = "id") Long id);

    /**
     * 修改
     *
     * @param dto 修改参数
     * @return
     */
    @RequestMapping(value = "/facade/developer/update", method = RequestMethod.PUT, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Boolean> update(@RequestBody DeveloperFacadeDTO dto);

    /**
     * 根据参数查询应用列表信息
     * @param dto
     * @return
     */
    @RequestMapping(value = "/facade/developer/getAppList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<List<DeveloperFacadeVO>> getAppList(@RequestBody DeveloperFacadeQueryDTO dto);

    /**
     * 根据参数查询开发者appKey的集合
     * @param dto
     * @return
     */
    @RequestMapping(value = "/facade/developer/getAppKeyList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<List<String>> getAppKeyList(@RequestBody DeveloperFacadeQueryDTO dto);

    /**
     * 根据appKey查询开发者详细信息
     * @param appKey
     * @return
     */
    @RequestMapping(value = "/facade/developer/getByAppKey", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<DeveloperFacadeVO> getAppInfoByAppKey(@RequestParam(value = "appKey") String appKey);

    /**
     * 根据关键字查询app列表
     * @param keyword 关键字：appName,别名,媒介
     * @return
     */
    @RequestMapping(value = "/facade/developer/getList", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<List<DeveloperFacadeVO>> getList(@RequestParam(value = "keyword", required = false) String keyword);

    /**
     * 根据帐户的预付类型查询app列表
     * @param advanceType 预付类型：0 非预付; 1 预付
     * @param keyword appkey，多个用逗号分隔
     * @return
     */
    @RequestMapping(value = "/facade/developer/getListByAdvanceType", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<List<DeveloperFacadeVO>> getListByAdvanceType(@RequestParam(value = "advanceType", required = false) Integer advanceType,
                                                              @RequestParam(value = "keyword", required = false) String keyword);

    /**
     * 给开发者设置媒介
     *
     * @param developerId 开发者ID
     * @param mjCode     媒介code
     * @param modifyUser   修改人
     * @return
     */
    @RequestMapping(value = "/facade/developer/setMj", method = RequestMethod.PUT, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Boolean> setMj(@RequestParam(value = "developerId") Long developerId,
                               @RequestParam(value = "mjCode") String mjCode,
                               @RequestParam(value = "modifyUser") String modifyUser);


    /**
     * 修改开发者基本数据 标签 bd mj
     *
     * @param developerId 开发者ID
     * @param mjCode     媒介code
     * @param bdCode      dbCode
     * @param tags        标签
     * @param modifyUser   修改人
     * @return
     */
    @RequestMapping(value = "/facade/developer/update-basic", method = RequestMethod.PUT, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Boolean> updateBasic(@RequestParam(value = "developerId") Long developerId,
                                @RequestParam(value = "mjCode") String mjCode,
                                @RequestParam(value = "bdCode") String bdCode,
                                @RequestParam(value = "tags") String tags,
                                @RequestParam(value = "modifyUser") String modifyUser);
}
