package com.bxm.mcssp.facade.model.developer;

import java.io.Serializable;
import java.time.LocalDateTime;

import com.fasterxml.jackson.annotation.JsonFormat;

import lombok.Data;
import lombok.ToString;

/**
 * <p>
 * 开发者分配列表
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-17
 */
@Data
@ToString
public class DeveloperAssignmentFacadeVO extends DeveloperBaseVO implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    /**
     * 提交审核时间
     * 开发者名称
     * 邮箱
     * 财务状态
     * 应用状态
     * 广告位状态
     * 媒介code
     * 媒介名称
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime submitReviewDate;
    private String developerName;
    private String email;

    private Integer financeStatus;
    private String appStatus;
    private String positionStatus;

    private String mjCode;
    private String mjName;

    private String bdCode;
    private String bdName;

    /**
     * 开发者标签id列表
     */
    private String tags;
    private String tagNames;

    /**
     * 是否可操作编辑
     */
    private boolean operatorEdit;

    /**
     * 是否可操作标签
     */
    private boolean operatorTag;

    /**
     * 是否可操作审核
     */
    private boolean operatorAudit;

}
