package com.bxm.mcssp.facade.model.position;

import java.io.Serializable;
import java.time.LocalDateTime;

import lombok.Data;

/**
 * <p>
 * 编辑,查询广告位组件
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-02-11
 */
@Data
public class PositionAssemblyFacadeDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 0未配置
     */
    public static final int CONFIG_FLAG_UN = 0;

    /**
     * 1已配置
     */
    public static final int CONFIG_FLAG_ALREADY = 1;

    /**
     * 0为开启
     */
    public static final Integer CLOSED_FLAG_OPEN = 0;

    /**
     * 1:关闭
     */
    public static final Integer CLOSED_FLAG_CLOSE = 1;

    /**
     * 广告位id标识
     */
    private String positionId;

    /**
     * 是否配置组件：0未配置，1已配置
     */
    private Integer configFlag;

    /**
     * 配置的组件名称，多个用逗号分隔
     */
    private String assemblys;

    /**
     * 是否已关闭：0为开启，1:关闭
     */
    private Integer closedFlag;

    /**
     * 修改人
     */
    private String modifyUser;

    /**
     * 修改时间
     */
    private LocalDateTime modifyTime;

}
