package com.bxm.mcssp.facade.model.position;

import java.io.Serializable;

import lombok.Data;

/**
 * <p>
 * 广告位组件信息综合类，集合了应用和开发者信息
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-02-11
 */
@Data
public class PositionAssemblyFacadeVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 广告位id标识
     */
    private String positionId;

    /**
     * 是否配置组件：0未配置，1已配置
     */
    private Integer configFlag;

    /**
     * 配置的组件名称，多个用逗号分隔
     */
    private String assemblys;

    /**
     * 是否已关闭：0为开启，1:关闭
     */
    private Integer closedFlag;


    //额外的信息
    //广告位的信息
    private String positionName;

    //开发者的信息
    /**
     * 媒体运营
     */
    private String mjCode;
    private String mjName;

}
