package com.bxm.mcssp.facade.model.position.sdkconfig;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * <p>
 * 修改广告位SDK配置
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-1-7
 */
@Data
public class PositionSdkConfigFacadeDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    private String positionId;

    private List<SdkConfig> configs;

    private String modifier;


    @Data
    public static class SdkConfig {

        /**
         * 开关状态：1.开, 0.关
         */
        public static final int STATUS_OPEN = 1;
        public static final int STATUS_CLOSE = 0;


        /**
         * id
         */
        private Long id;

        /**
         * 广告位Id
         */
        private String positionId;

        /**
         * 渠道类型
         */
        private String channelType;

        /**
         * 渠道应用id
         */
        private String channelApplicationId;

        /**
         * 渠道广告位Id
         */
        private String channelPositionId;

        /**
         * 排序
         */
        private Integer sort;

        /**
         * 超时时间
         */
        private Integer timeout;

        /**
         * 开关状态：1.开, 0.关
         */
        private Integer status;

        /**
         * 流量占比
         */
        private Integer rateOfFlow;

        /**
         * 频次控制
         */
        private Integer frequency;
    }
}
