package com.bxm.mcssp.facade.model.position.sdkconfig;

import java.io.Serializable;
import java.util.List;

import com.bxm.mcssp.facade.model.PageDTO;

import lombok.Data;

/**
 * <p>
 * 查询广告位SDK配置
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-08-11
 */
@Data
public class PositionSdkConfigFacadeQueryDTO extends PageDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    /**
     * 广告位Id
     */
    private String positionId;

    /**
     * 渠道类型
     */
    private String channelType;

    /**
     * 渠道应用id
     */
    private String channelApplicationId;

    /**
     * 渠道广告位Id
     */
    private String channelPositionId;

    /**
     * 排序
     */
    private Integer sort;

    /**
     * 超时时间
     */
    private Integer timeout;

    /**
     * 开关状态：1.开, 0.关
     */
    private Integer status;

    /**
     * 流量占比
     */
    private Integer rateOfFlow;

    /**
     * 频次控制
     */
    private Integer frequency;

    /**
     * 广告位position_id
     * position_id in ()
     */
    private List<String> positionIds;

    /**
     * 渠道广告位Id channel_position_id
     * channel_position_id in ()
     */
    private List<String> channelPositionIds;



}
