package com.bxm.mcssp.facade.service;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.mcssp.facade.constant.Constants;
import com.bxm.mcssp.facade.model.developer.DeveloperAssignmentFacadeVO;
import com.bxm.mcssp.facade.model.developer.DeveloperFinanceListFacadeVO;
import com.bxm.mcssp.facade.model.developer.DeveloperFirstAuditResultFacadeVO;

/**
 * <p>
 * 开发者财务信息 feign client 服务
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-18
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface DeveloperFinanceFacadeService {

    /**
     * 运营后台开发者分配页列表
     * @param developerKeyword 开发者名称
     * @param email 电子邮件
     * @param financeStatus 财务信息状态
     * @param appStatus 应用状态
     * @param positionStatus 广告位状态
     * @param mjCode 媒介code
     * @param isOrderByDateDesc 是否按提交时间降序
     * @param current 页码
     * @param size 页面大小
     * @return
     */
    @RequestMapping(value = "/facade/developerFinance/getAssignmentPage", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Page<DeveloperAssignmentFacadeVO>> getAssignmentPage(@RequestParam(name = "developerKeyword", required = false) String developerKeyword,
                                                                        @RequestParam(name = "email", required = false) String email,
                                                                        @RequestParam(name = "financeStatus", required = false) Integer financeStatus,
                                                                        @RequestParam(name = "appStatus", required = false) Integer appStatus,
                                                                        @RequestParam(name = "positionStatus", required = false) Integer positionStatus,
                                                                        @RequestParam(name = "mjCode", required = false) String mjCode,
                                                                        @RequestParam(name = "bdCode", required = false) String bdCode,
                                                                        @RequestParam(name = "isOrderByDateDesc", required = false) Boolean isOrderByDateDesc,
                                                                        @RequestParam(name = "code", required = false) String code,
                                                                        @RequestParam(name = "current", required = false, defaultValue = "1") Integer current,
                                                                        @RequestParam(name = "size", required = false, defaultValue = "20") Integer size);

    /**
     * 运营后台开发者财务管理列表
     *
     * @param developerKeyword 邮箱/手机/公司名称/应用名称
     * @param mjCode   媒介code
     * @developerId  开发者id
     * @param status   状态，-1：未提交 0：待审核，1：审核通过，2：审核拒绝
     * @param current  页码
     * @param size 页面大小
     * @return
     */
    @RequestMapping(value = "/facade/developerFinance/getAuditPage", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Page<DeveloperFinanceListFacadeVO>> getAuditPage(@RequestParam(name = "developerKeyword", required = false) String developerKeyword,
                                                                     @RequestParam(name = "mjCode", required = false) String mjCode,
                                                                     @RequestParam(name = "developerId", required = false, defaultValue = "-1")long provideId,
                                                                     @RequestParam(name = "status", required = false) Integer status,
                                                                     @RequestParam(name = "current", required = false, defaultValue = "1") Integer current,
                                                                     @RequestParam(name = "size", required = false, defaultValue = "20") Integer size);


    /**
     * 审核开发者财务信息
     *
     * @param developerId   开发者ID
     * @param auditPass    是否审核通过, TRUE通过， FALSE拒绝
     * @param refuseReason 拒绝原因
     * @param reviewRefuseIds 拒绝原因ID列表
     * @param modifyUser     修改人
     * @param  isRiskController 是否为风控
     * @return
     */
    @RequestMapping(value = "/facade/developerFinance/audit", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Boolean> audit(@RequestParam(name = "developerId") Long developerId,
                               @RequestParam(name = "auditPass") Boolean auditPass,
                               @RequestParam(name = "refuseReason") String refuseReason,
                               @RequestParam(name = "reviewRefuseIds") String reviewRefuseIds,
                               @RequestParam(name = "modifyUser") String modifyUser,
                               @RequestParam(name = "isRiskController") boolean isRiskController);


    /**
     * 运营后台开发者分配列表中媒介leader初审(风控可跳过媒介)
     *
     * @param developerId   开发者ID
     * @param auditPass    是否审核通过, TRUE通过， FALSE拒绝
     * @param modifyUser     修改人
     * @param isRiskController 是否为风控
     * @return
     */
    @RequestMapping(value = "/facade/developerFinance/firstAudit", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<DeveloperFirstAuditResultFacadeVO> firstAudit(@RequestParam(name = "developerId") Long developerId,
                                                                 @RequestParam(name = "auditPass") Boolean auditPass,
                                                                 @RequestParam(name = "modifyUser") String modifyUser,
                                                                 @RequestParam(name = "isRiskController") boolean isRiskController);


}
