package com.bxm.mcssp.facade.service;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.mcssp.facade.constant.Constants;
import com.bxm.mcssp.facade.model.position.PositionAssemblyFacadeDTO;
import com.bxm.mcssp.facade.model.position.PositionAssemblyFacadeQueryDTO;
import com.bxm.mcssp.facade.model.position.PositionAssemblyFacadeVO;

/**
 * <p>
 * 广告位组件 feign client 服务
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-02-11
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface PositionAssemblyFacadeService {

    /**
     * 分页查询
     *
     * @param dto 查询参数
     * @return
     */
    @RequestMapping(value = "/facade/position/assembly/page", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Page<PositionAssemblyFacadeVO>> page(@RequestBody PositionAssemblyFacadeQueryDTO dto);

    /**
     * 修改
     *
     * @param dto 修改参数
     * @return
     */
    @RequestMapping(value = "/facade/position/assembly/update", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Boolean> update(@RequestBody PositionAssemblyFacadeDTO dto);


    /**
     * 修改 状态
     *
     * @param dto 修改参数
     * @return
     */
    @RequestMapping(value = "/facade/position/assembly/updateCloseFlag", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Boolean> updateCloseFlag(@RequestBody PositionAssemblyFacadeDTO dto);

}
