package com.bxm.mcssp.facade.service;

import java.util.List;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.mcssp.common.entity.IDAndNameVO;
import com.bxm.mcssp.facade.constant.Constants;
import com.bxm.mcssp.facade.model.position.PositionAuditFacadeVO;
import com.bxm.mcssp.facade.model.position.PositionFacadeDTO;
import com.bxm.mcssp.facade.model.position.PositionFacadeQueryDTO;
import com.bxm.mcssp.facade.model.position.PositionFacadeVO;

/**
 * <p>
 * 广告位 feign client 服务
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-18
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface PositionFacadeService {

    /**
     * ID和名称数据，主要用于下拉框填充
     *
     * @param keyword 查询参数
     * @return
     */
    @RequestMapping(value = "/facade/position/common/list", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<List<IDAndNameVO>> list(@RequestParam(value = "keyword", required = false) String keyword);

    /**
     * 分页查询
     *
     * @param dto 查询参数
     * @return
     */
    @RequestMapping(value = "/facade/position/page", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Page<PositionFacadeVO>> page(@RequestBody PositionFacadeQueryDTO dto);

    /**
     * 根据id查询
     *
     * @param id id
     * @return
     */
    @RequestMapping(value = "/facade/position/get", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<PositionFacadeVO> get(@RequestParam(value = "id") Long id);

    /**
     * 修改
     *
     * @param dto 修改参数
     * @return
     */
    @RequestMapping(value = "/facade/position/update", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Boolean> update(@RequestBody PositionFacadeDTO dto);

    /**
     * 列表
     *
     * @param dto 查询条件
     * @return
     */
    @RequestMapping(value = "/facade/position/getList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<List<PositionFacadeVO>> getList(@RequestBody PositionFacadeQueryDTO dto);

    /**
     * 根据 positionId 查询广告位
     *
     * @param positionId 广告位ID
     * @return
     */
    @RequestMapping(value = "/facade/position/findByPositionId", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<PositionFacadeVO> findByPositionId(@RequestParam(name = "positionId") String positionId);

    /**
     * 根据 positionId 查询广告位
     * 这里会返回包含不同广告位类型的配置信息
     * @param positionId 广告位ID
     * @return
     */
    @RequestMapping(value = "/facade/position/findAllInfoByPositionId", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<PositionFacadeVO> findAllInfoByPositionId(@RequestParam(name = "positionId") String positionId);

    /**
     * 根据广告位ID集合查询广告位
     *
     * @param positionIdsStr 广告位ID集合字符串，逗号分隔
     * @return
     */
    @RequestMapping(value = "/facade/position/findListByPositionIds", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<List<PositionFacadeVO>> findListByPositionIds(@RequestParam(name = "positionIdsStr") String positionIdsStr);

    /**
     * 根据主键集合查询广告位
     *
     * @param idsStr 主键字符串， 逗号分隔
     * @return
     */
    @RequestMapping(value = "/facade/position/findByIds", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<List<PositionFacadeVO>> findByIds(@RequestParam(name = "idsStr") String idsStr);

    /**
     * 运营后台查询审核页面的 广告位列表
     *
     * @param developerKeyword 邮箱/手机/公司名称
     * @param appKeyword 应用ID/应用名称
     * @param positionKeyword 广告位ID/广告位名称
     * @param status   状态
     * @param mjCode   媒介code
     * @param current  页码
     * @param size 页面大小
     * @return
     */
    @RequestMapping(value = "/facade/position/getAuditPage", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Page<PositionAuditFacadeVO>> getAuditPage(@RequestParam(name = "developerKeyword", required = false) String developerKeyword,
                                                             @RequestParam(name = "appKeyword", required = false) String appKeyword,
                                                             @RequestParam(name = "positionKeyword", required = false) String positionKeyword,
                                                             @RequestParam(name = "status", required = false) Integer status,
                                                             @RequestParam(name = "developerId", required = false, defaultValue = "-1") Long developerId,
                                                             @RequestParam(name = "mjCode", required = false) String mjCode,
                                                             @RequestParam(name = "current", defaultValue = "1") Integer current,
                                                             @RequestParam(name = "size", defaultValue = "20") Integer size);

    /**
     * 批量审核广告位
     *
     * @param idsStr       id字符串， 逗号分隔
     * @param auditPass    审核通过
     * @param isMJ         是否是媒介审核
     * @param refuseReason 拒绝理由
     * @param reviewRefuseIds 拒绝原因ID列表
     * @param modifyUser     审核人
     * @return
     */
    @RequestMapping(value = "/facade/position/batchAudit", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<List<Long>> batchAudit(@RequestParam("idsStr") String idsStr,
                                    @RequestParam("auditPass") Boolean auditPass,
                                    @RequestParam("isMJ") Boolean isMJ,
                                    @RequestParam("refuseReason") String refuseReason,
                                    @RequestParam("reviewRefuseIds") String reviewRefuseIds,
                                    @RequestParam("modifyUser") String modifyUser);

    /**
     * 广告位开关
     *
     * @param positionId 广告位ID
     * @param closedFlag  是否开关， true关，false开
     * @param modifyUser   修改者
     * @return
     */
    @RequestMapping(value = "/facade/position/positionSwitch", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Boolean> positionSwitch(@RequestParam("positionId") String positionId,
                                        @RequestParam("closedFlag") Boolean closedFlag,
                                        @RequestParam("modifyUser") String modifyUser);

    /**
     * 通过主键来查广告位ID
     *
     * @param ids 为json字符串
     * @return
     */
    @RequestMapping(value = "/facade/position/getPositionIdsByIds", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<List<String>> getPositionIdsByIds(@RequestParam(value = "ids") String ids);


    /**
     * 条件查询所有广告位ID集合
     */
    @RequestMapping(value = "/facade/position/getAllPositionIds", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<List<String>> getAllPositionIds(@RequestBody PositionFacadeQueryDTO dto);

    /**
     * 创建激励视频广告位
     */
    @Deprecated
    @RequestMapping(value = "/facade/position/addInspireVideoPosition", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Long> addInspireVideoPosition(@RequestParam("appId") Long appId);

    /**
     * 应用通过审核后创建广告位
     */
    @RequestMapping(value = "/facade/position/addPosition", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<List<Long>> addPosition(@RequestParam("appId") Long appId);

    /**
     * 同步广告位到互动开发者平台
     *
     * @param positionIdsStr 广告位ID集合字符串，逗号分隔
     * @return
     */
    @RequestMapping(value = "/facade/position/syncPositionToInteract", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Boolean> syncPositionToInteract(@RequestParam(name = "positionIdsStr") String positionIdsStr);
}
