package com.bxm.mcssp.facade.model.developer;

import java.io.Serializable;

import lombok.Data;
import lombok.ToString;

/**
 * <p>
 * 编辑开发者基础信息
 * </p>
 *
 * @author zhengwangeng
 * @since 2022-5-23
 */
@Data
@ToString
public class DeveloperFacadeUpdateBaseDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    private Long id;

    /**
     * 媒体运营
     */
    private String mjCode;

    /**
     * 商务BD
     */
    private String bdCode;

    /**
     * 开发者标签，多个标签用逗号分隔
     */
    private String tags;

    /**
     * 对接类型：1 API，2 SDK
     * @see com.bxm.mcssp.common.enums.app.DockingMethodTypeEnum
     */
    private Integer dockingMethodType;

    /**
     * 修改人
     */
    private String modifyUser;



}
