package com.bxm.mcssp.integration.acl;

import java.util.HashMap;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.stereotype.Component;

import com.bxm.acl.facade.AclUserService;
import com.bxm.acl.facade.model.ResultModel;
import com.bxm.acl.facade.model.UserRo;

import lombok.extern.slf4j.Slf4j;

/**
 * <p>
 * 权限系统 服务调用
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-17
 */
@Slf4j
@Component
@EnableFeignClients("com.bxm.acl.facade")
public class AclUserIntegration {

    @Autowired
    private AclUserService aclUserService;

    public Map<String, String> queryUserByRoleCode(String roleCode, Boolean onlyShowEnable) {
        try {
            ResultModel<Map<String, String>> response = aclUserService.queryUserByRoleCode(roleCode, false);
            if (response != null && response.isSuccessed() && response.getReturnValue() != null) {
                return response.getReturnValue();
            }
        } catch (Exception e){
            log.error("请求权限系统查询角色对应用户信息异常:", e);
        }
        return new HashMap<>(0);
    }

    public UserRo queryUserByUsername(String username) {
        try {
            ResultModel<UserRo> response = aclUserService.getUserByUsername(username);
            if (response != null && response.isSuccessed() && response.getReturnValue() != null) {
                return response.getReturnValue();
            }
        } catch (Exception e) {
            log.error("请求权限系统查询username对应用户信息异常:", e);
        }
        return null;
    }
}
