package com.bxm.mcssp.integration.adsmedia;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.stereotype.Component;

import com.bxm.adsmedia.facade.enumdata.CaptchaSceneEnum;
import com.bxm.adsmedia.facade.ssp.ProviderFinance;
import com.bxm.adsmedia.facade.ssp.SSPFacadeService;
import com.bxm.adsmedia.facade.ssp.UserRegister;
import com.bxm.adsmedia.facade.ssp.sync.SyncSSPInfoDTO;
import com.bxm.adsmedia.facade.ssp.sync.SyncSSPInfoResultDTO;
import com.bxm.mcssp.common.exception.BusinessException;
import com.bxm.warcar.utils.response.ResultModel;

import lombok.extern.slf4j.Slf4j;

/**
 * <p>
 * adsmedia integration 调用
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-17
 */
@Slf4j
@Component
@EnableFeignClients("com.bxm.adsmedia.facade")
public class AdsMediaAuthIntegration {

    @Autowired
    private SSPFacadeService sspFacadeService;

    public byte[] imgCaptchaGet(String uuid, Byte scene) {
        return sspFacadeService.imgCaptchaGet(uuid, scene);
    }

    public Boolean imgCaptchaVerify(String uuid, Byte sceneCode, String captcha) {
        ResultModel<Boolean> resultModel = sspFacadeService.imgCaptchaVerify(uuid, sceneCode, captcha);
        if (resultModel.isSuccessed()) {
            return resultModel.getReturnValue();
        }
        log.error("调用服务失败！-->{},{}", resultModel.getErrorCode(), resultModel.getErrorDesc());
        throw new BusinessException(resultModel.getErrorDesc());
    }

    public Boolean register(UserRegister userRegister) {
        ResultModel<Boolean> resultModel = sspFacadeService.register(userRegister);
        if (resultModel.isSuccessed()) {
            return resultModel.getReturnValue();
        }
        log.error("调用服务失败！-->{},{}", resultModel.getErrorCode(), resultModel.getErrorDesc());
        throw new BusinessException(resultModel.getErrorDesc());
    }

    public UserRegister login(String uuid, String uName, String pwd, String captcha) {
        ResultModel<UserRegister> resultModel = sspFacadeService.login(uuid, uName, pwd, captcha);
        if (resultModel.isSuccessed()) {
            return resultModel.getReturnValue();
        }
        log.error("调用服务失败！-->{},{}", resultModel.getErrorCode(), resultModel.getErrorDesc());
        throw new BusinessException(resultModel.getErrorDesc());
    }

    public Boolean smsCaptcha(CaptchaSceneEnum captchaSceneEnum, String phoneNum, String context) {
        ResultModel<Boolean> resultModel = sspFacadeService.smsCaptcha(captchaSceneEnum, phoneNum, context);
        if (resultModel.isSuccessed()) {
            return resultModel.getReturnValue();
        }
        log.error("调用服务失败！-->{},{}", resultModel.getErrorCode(), resultModel.getErrorDesc());
        throw new BusinessException(resultModel.getErrorDesc());
    }

    public Boolean validatedSmsCaptcha(CaptchaSceneEnum captchaSceneEnum, String captcha, String phoneNum) {
        ResultModel<Boolean> resultModel = sspFacadeService.validatedSmsCaptcha(captchaSceneEnum, captcha, phoneNum);
        if (resultModel.isSuccessed()) {
            return resultModel.getReturnValue();
        }
        log.error("调用服务失败！-->{},{}", resultModel.getErrorCode(), resultModel.getErrorDesc());
        throw new BusinessException(resultModel.getErrorDesc());
    }

    public Boolean registerSmsCaptchaGet(String uuid, String captcha, String phoneNum) {
        ResultModel<Boolean> resultModel = sspFacadeService.registerSmsCaptchaGet(uuid, captcha, phoneNum);
        if (resultModel.isSuccessed()) {
            return resultModel.getReturnValue();
        }
        log.error("调用服务失败！-->{},{}", resultModel.getErrorCode(), resultModel.getErrorDesc());
        throw new BusinessException(resultModel.getErrorDesc());
    }

    public Boolean checkEmailExist(String email) {
        ResultModel<Boolean> resultModel = sspFacadeService.checkEmailExist(email);
        if (resultModel.isSuccessed()) {
            return resultModel.getReturnValue();
        }
        log.error("调用服务失败！-->{},{}", resultModel.getErrorCode(), resultModel.getErrorDesc());
        throw new BusinessException(resultModel.getErrorDesc());
    }

    public Boolean checkPhoneNumExist(String phoneNum) {
        ResultModel<Boolean> resultModel = sspFacadeService.checkPhoneNumExist(phoneNum);
        if (resultModel.isSuccessed()) {
            return resultModel.getReturnValue();
        }
        log.error("调用服务失败！-->{},{}", resultModel.getErrorCode(), resultModel.getErrorDesc());
        throw new BusinessException(resultModel.getErrorDesc());
    }

    public Boolean forgetPwdSmsCaptchaGet(String uuid, String captcha, String phoneNum) {
        ResultModel<Boolean> resultModel = sspFacadeService.forgetPwdSmsCaptchaGet(uuid, captcha, phoneNum);
        if (resultModel.isSuccessed()) {
            return resultModel.getReturnValue();
        }
        log.error("调用服务失败！-->{},{}", resultModel.getErrorCode(), resultModel.getErrorDesc());
        throw new BusinessException(resultModel.getErrorDesc());
    }

    public Boolean forgetPwd(String newPwd, String phoneNum, String captcha) {
        return sspFacadeService.forgetPwd(newPwd, phoneNum, captcha).getReturnValue();
    }

    public String getAppSecretByAppKey(String appKey) {
        ResultModel<String> resultModel = sspFacadeService.getAppSecretByAppKey(appKey);
        if (resultModel.isSuccessed()) {
            return resultModel.getReturnValue();
        }
        log.error("调用服务失败！-->{},{}", resultModel.getErrorCode(), resultModel.getErrorDesc());
        throw new BusinessException(resultModel.getErrorDesc());
    }

    public UserRegister getBaseInfo(Long id) {
        ResultModel<UserRegister> resultModel = sspFacadeService.getBaseInfo(id);
        if (resultModel.isSuccessed()) {
            return resultModel.getReturnValue();
        }
        log.error("调用服务失败！-->{},{}", resultModel.getErrorCode(), resultModel.getErrorDesc());
        throw new BusinessException(resultModel.getErrorDesc());
    }

    public Boolean updateBaseInfo(UserRegister dto) {
        ResultModel<Boolean> resultModel = sspFacadeService.updateBaseInfo(dto);
        if (resultModel.isSuccessed()) {
            return resultModel.getReturnValue();
        }
        log.error("调用服务失败！-->{},{}", resultModel.getErrorCode(), resultModel.getErrorDesc());
        throw new BusinessException(resultModel.getErrorDesc());
    }

    public ProviderFinance getFinanceInfo(Long id) {
        ResultModel<ProviderFinance> resultModel = sspFacadeService.getFinanceInfo(id);
        if (resultModel.isSuccessed()) {
            return resultModel.getReturnValue();
        }
        log.error("调用服务失败！-->{},{}", resultModel.getErrorCode(), resultModel.getErrorDesc());
        throw new BusinessException(resultModel.getErrorDesc());
    }

    public Boolean updatePhoneNumSmsCaptchaGet(String phoneNum) {
        ResultModel<Boolean> resultModel = sspFacadeService.updatePhoneNumSmsCaptchaGet(phoneNum);
        if (resultModel.isSuccessed()) {
            return resultModel.getReturnValue();
        }
        log.error("调用服务失败！-->{},{}", resultModel.getErrorCode(), resultModel.getErrorDesc());
        throw new BusinessException(resultModel.getErrorDesc());
    }

    /**
     * 同步广告位信息
     */
    public SyncSSPInfoResultDTO syncPosition(SyncSSPInfoDTO syncSSPInfoDTO) {
        ResultModel<SyncSSPInfoResultDTO> resultModel =
                sspFacadeService.syncPosition(syncSSPInfoDTO);
        if (resultModel.isSuccessed()) {
            return resultModel.getReturnValue();
        }
        log.error("调用服务失败！-->{},{}", resultModel.getErrorCode(), resultModel.getErrorDesc());
        throw new BusinessException(resultModel.getErrorDesc());
    }
}
