package com.bxm.mcssp.integration.datapark;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.stereotype.Component;

import com.bxm.datapark.facade.Page;
import com.bxm.datapark.web.FacadeAssemblyDataService;
import com.bxm.datapark.web.model.AssemblyData;
import com.bxm.datapark.web.model.AssemblyDataDTO;
import com.bxm.warcar.utils.response.ResultModel;

import lombok.extern.slf4j.Slf4j;


/**
 * <p>
 * datapark 服务
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-2-12
 */
@Slf4j
@Component
@EnableFeignClients("com.bxm.datapark.web")
public class DataParkIntegration {

    @Autowired
    private FacadeAssemblyDataService facadeAssemblyDataService;

    public Page<AssemblyData> getAssemblyData(AssemblyDataDTO search) {
        try {
            ResultModel<Page<AssemblyData>> resultModel = facadeAssemblyDataService.getAssemblyData(search);
            if (resultModel.isSuccessed()) {
                return resultModel.getReturnValue();
            }
            log.error("调用datapark getAssemblyData 服务失败！-->{},{}", resultModel.getErrorCode(), resultModel.getErrorDesc());
        } catch (Exception e) {
            log.error("调用datapark getAssemblyData 服务异常！", e);
        }
        return new Page<>();
    }
}
