package com.bxm.mcssp.integration.mccms;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import com.bxm.mccms.facade.service.IPositionDspPosFacadeService;

import lombok.extern.slf4j.Slf4j;

/**
 * <p>
 * mccms integration 流量分配调用
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-10-21
 */
@Slf4j
@Component
@EnableFeignClients("com.bxm.mccms.facade")
public class PositionDspPosIntegration {

    @Autowired
    private IPositionDspPosFacadeService positionDspPosFacadeService;

    public Boolean addSspSyncInspireVideoDsp(String positionId, String dspPosid) {
        ResponseEntity<Boolean> responseEntity = positionDspPosFacadeService.addSspSyncInspireVideoDsp(
                positionId, dspPosid);
        if (HttpStatus.OK.equals(responseEntity.getStatusCode())) {
            return responseEntity.getBody();
        }
        log.error("运营后台异常，添加激励视频流量分配失败！-->{}", responseEntity.getStatusCodeValue());
        return Boolean.FALSE;
    }

    public Boolean addSspSyncVideotexDsp(String positionId, String dspPosid) {
        ResponseEntity<Boolean> responseEntity = positionDspPosFacadeService.addSspSyncVideotexDsp(
                positionId, dspPosid);
        if (HttpStatus.OK.equals(responseEntity.getStatusCode())) {
            return responseEntity.getBody();
        }
        log.error("运营后台异常，添加图文DSP流量分配失败！-->{}", responseEntity.getStatusCodeValue());
        return Boolean.FALSE;
    }
}
