package com.bxm.mcssp.integration.mccms;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import com.bxm.mccms.facade.model.reviewrefuseconfig.ReviewRefuseConfigFacadeDTO;
import com.bxm.mccms.facade.model.reviewrefuseconfig.ReviewRefuseConfigFacadeVO;
import com.bxm.mccms.facade.service.IReviewRefuseConfigFacadeService;

import lombok.extern.slf4j.Slf4j;

/**
 * <p>
 * mccms integration 审核维护配置调用
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-22
 */
@Slf4j
@Component
@EnableFeignClients("com.bxm.mccms.facade")
public class ReviewRefuseConfigIntegration {

    @Autowired
    private IReviewRefuseConfigFacadeService reviewRefuseConfigFacadeService;

    public List<ReviewRefuseConfigFacadeVO> list(ReviewRefuseConfigFacadeDTO dto) {
        ResponseEntity<List<ReviewRefuseConfigFacadeVO>> responseEntity = reviewRefuseConfigFacadeService.list(dto);
        return responseEntity.getBody();
    }

    public List<ReviewRefuseConfigFacadeVO> listByIds(List<Long> ids) {
        ResponseEntity<List<ReviewRefuseConfigFacadeVO>> responseEntity = reviewRefuseConfigFacadeService.listByIds(ids);
        return responseEntity.getBody();
    }
}
