package com.bxm.mcssp.integration.mccms;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import com.bxm.mccms.facade.model.sysdict.SysDictFacadeVO;
import com.bxm.mccms.facade.service.ISysDictFacadeService;

import lombok.extern.slf4j.Slf4j;

/**
 * <p>
 * mccms integration 系统字典调用
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-20
 */
@Slf4j
@Component
@EnableFeignClients("com.bxm.mccms.facade")
public class SysDictIntegration {

    @Autowired
    private ISysDictFacadeService sysDictFacadeService;

    public List<SysDictFacadeVO> list(String typeCode, String parentDictValue) {
        ResponseEntity<List<SysDictFacadeVO>> responseEntity = sysDictFacadeService.list(typeCode, parentDictValue);
        if (HttpStatus.OK.equals(responseEntity.getStatusCode())) {
            return responseEntity.getBody();
        }
        log.error("运营后台异常，查询系统字典列表失败！-->{}", responseEntity.getStatusCodeValue());
        return Collections.emptyList();
    }

    public Map<String, String> getSysDictByTypeCode(String typeCode) {
        List<SysDictFacadeVO> list = list(typeCode, StringUtils.EMPTY);
        if (CollectionUtils.isNotEmpty(list)) {
            Map<String, String> map = list.stream().collect(HashMap::new, (k, v) -> k.put(v.getDictValue(), v.getDictName()), HashMap::putAll);
            return map;
        }
        return Collections.emptyMap();
    }
}
