/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mcssp.integration.adsmedia;

import com.bxm.adsmedia.facade.enumdata.CaptchaSceneEnum;
import com.bxm.adsmedia.facade.ssp.ProviderFinance;
import com.bxm.adsmedia.facade.ssp.SSPFacadeService;
import com.bxm.adsmedia.facade.ssp.UserRegister;
import com.bxm.adsmedia.facade.ssp.sync.SyncSSPInfoDTO;
import com.bxm.adsmedia.facade.ssp.sync.SyncSSPInfoResultDTO;
import com.bxm.mcssp.common.exception.BusinessException;
import com.bxm.warcar.utils.response.ResultModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.stereotype.Component;

@Component
@EnableFeignClients(value={"com.bxm.adsmedia.facade"})
public class AdsMediaAuthIntegration {
    private static final Logger log = LoggerFactory.getLogger(AdsMediaAuthIntegration.class);
    @Autowired
    private SSPFacadeService sspFacadeService;

    public byte[] imgCaptchaGet(String uuid, Byte scene) {
        return this.sspFacadeService.imgCaptchaGet(uuid, scene);
    }

    public Boolean imgCaptchaVerify(String uuid, Byte sceneCode, String captcha) {
        ResultModel resultModel = this.sspFacadeService.imgCaptchaVerify(uuid, sceneCode, captcha);
        if (resultModel.isSuccessed()) {
            return (Boolean)resultModel.getReturnValue();
        }
        log.error("\u8c03\u7528\u670d\u52a1\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        throw new BusinessException(resultModel.getErrorDesc());
    }

    public Boolean register(UserRegister userRegister) {
        ResultModel resultModel = this.sspFacadeService.register(userRegister);
        if (resultModel.isSuccessed()) {
            return (Boolean)resultModel.getReturnValue();
        }
        log.error("\u8c03\u7528\u670d\u52a1\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        throw new BusinessException(resultModel.getErrorDesc());
    }

    public UserRegister login(String uuid, String uName, String pwd, String captcha) {
        ResultModel resultModel = this.sspFacadeService.login(uuid, uName, pwd, captcha);
        if (resultModel.isSuccessed()) {
            return (UserRegister)resultModel.getReturnValue();
        }
        log.error("\u8c03\u7528\u670d\u52a1\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        throw new BusinessException(resultModel.getErrorDesc());
    }

    public Boolean smsCaptcha(CaptchaSceneEnum captchaSceneEnum, String phoneNum, String context) {
        ResultModel resultModel = this.sspFacadeService.smsCaptcha(captchaSceneEnum, phoneNum, context);
        if (resultModel.isSuccessed()) {
            return (Boolean)resultModel.getReturnValue();
        }
        log.error("\u8c03\u7528\u670d\u52a1\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        throw new BusinessException(resultModel.getErrorDesc());
    }

    public Boolean validatedSmsCaptcha(CaptchaSceneEnum captchaSceneEnum, String captcha, String phoneNum) {
        ResultModel resultModel = this.sspFacadeService.validatedSmsCaptcha(captchaSceneEnum, captcha, phoneNum);
        if (resultModel.isSuccessed()) {
            return (Boolean)resultModel.getReturnValue();
        }
        log.error("\u8c03\u7528\u670d\u52a1\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        throw new BusinessException(resultModel.getErrorDesc());
    }

    public Boolean registerSmsCaptchaGet(String uuid, String captcha, String phoneNum) {
        ResultModel resultModel = this.sspFacadeService.registerSmsCaptchaGet(uuid, captcha, phoneNum);
        if (resultModel.isSuccessed()) {
            return (Boolean)resultModel.getReturnValue();
        }
        log.error("\u8c03\u7528\u670d\u52a1\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        throw new BusinessException(resultModel.getErrorDesc());
    }

    public Boolean checkEmailExist(String email) {
        ResultModel resultModel = this.sspFacadeService.checkEmailExist(email);
        if (resultModel.isSuccessed()) {
            return (Boolean)resultModel.getReturnValue();
        }
        log.error("\u8c03\u7528\u670d\u52a1\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        throw new BusinessException(resultModel.getErrorDesc());
    }

    public Boolean checkPhoneNumExist(String phoneNum) {
        ResultModel resultModel = this.sspFacadeService.checkPhoneNumExist(phoneNum);
        if (resultModel.isSuccessed()) {
            return (Boolean)resultModel.getReturnValue();
        }
        log.error("\u8c03\u7528\u670d\u52a1\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        throw new BusinessException(resultModel.getErrorDesc());
    }

    public Boolean forgetPwdSmsCaptchaGet(String uuid, String captcha, String phoneNum) {
        ResultModel resultModel = this.sspFacadeService.forgetPwdSmsCaptchaGet(uuid, captcha, phoneNum);
        if (resultModel.isSuccessed()) {
            return (Boolean)resultModel.getReturnValue();
        }
        log.error("\u8c03\u7528\u670d\u52a1\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        throw new BusinessException(resultModel.getErrorDesc());
    }

    public Boolean forgetPwd(String newPwd, String phoneNum, String captcha) {
        return (Boolean)this.sspFacadeService.forgetPwd(newPwd, phoneNum, captcha).getReturnValue();
    }

    public String getAppSecretByAppKey(String appKey) {
        ResultModel resultModel = this.sspFacadeService.getAppSecretByAppKey(appKey);
        if (resultModel.isSuccessed()) {
            return (String)resultModel.getReturnValue();
        }
        log.error("\u8c03\u7528\u670d\u52a1\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        throw new BusinessException(resultModel.getErrorDesc());
    }

    public UserRegister getBaseInfo(Long id) {
        ResultModel resultModel = this.sspFacadeService.getBaseInfo(id);
        if (resultModel.isSuccessed()) {
            return (UserRegister)resultModel.getReturnValue();
        }
        log.error("\u8c03\u7528\u670d\u52a1\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        throw new BusinessException(resultModel.getErrorDesc());
    }

    public Boolean updateBaseInfo(UserRegister dto) {
        ResultModel resultModel = this.sspFacadeService.updateBaseInfo(dto);
        if (resultModel.isSuccessed()) {
            return (Boolean)resultModel.getReturnValue();
        }
        log.error("\u8c03\u7528\u670d\u52a1\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        throw new BusinessException(resultModel.getErrorDesc());
    }

    public ProviderFinance getFinanceInfo(Long id) {
        ResultModel resultModel = this.sspFacadeService.getFinanceInfo(id);
        if (resultModel.isSuccessed()) {
            return (ProviderFinance)resultModel.getReturnValue();
        }
        log.error("\u8c03\u7528\u670d\u52a1\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        throw new BusinessException(resultModel.getErrorDesc());
    }

    public Boolean updatePhoneNumSmsCaptchaGet(String phoneNum) {
        ResultModel resultModel = this.sspFacadeService.updatePhoneNumSmsCaptchaGet(phoneNum);
        if (resultModel.isSuccessed()) {
            return (Boolean)resultModel.getReturnValue();
        }
        log.error("\u8c03\u7528\u670d\u52a1\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        throw new BusinessException(resultModel.getErrorDesc());
    }

    public SyncSSPInfoResultDTO syncPosition(SyncSSPInfoDTO syncSSPInfoDTO) {
        ResultModel resultModel = this.sspFacadeService.syncPosition(syncSSPInfoDTO);
        if (resultModel.isSuccessed()) {
            return (SyncSSPInfoResultDTO)resultModel.getReturnValue();
        }
        log.error("\u8c03\u7528\u670d\u52a1\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        throw new BusinessException(resultModel.getErrorDesc());
    }
}

