/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mcssp.integration.datapark;

import com.bxm.datapark.facade.Page;
import com.bxm.datapark.web.FacadeAssemblyDataService;
import com.bxm.datapark.web.model.AssemblyData;
import com.bxm.datapark.web.model.AssemblyDataDTO;
import com.bxm.warcar.utils.response.ResultModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.stereotype.Component;

@Component
@EnableFeignClients(value={"com.bxm.datapark.web"})
public class DataParkIntegration {
    private static final Logger log = LoggerFactory.getLogger(DataParkIntegration.class);
    @Autowired
    private FacadeAssemblyDataService facadeAssemblyDataService;

    public Page<AssemblyData> getAssemblyData(AssemblyDataDTO search) {
        try {
            ResultModel resultModel = this.facadeAssemblyDataService.getAssemblyData(search);
            if (resultModel.isSuccessed()) {
                return (Page)resultModel.getReturnValue();
            }
            log.error("\u8c03\u7528datapark getAssemblyData \u670d\u52a1\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u8c03\u7528datapark getAssemblyData \u670d\u52a1\u5f02\u5e38\uff01", (Throwable)e);
        }
        return new Page();
    }
}

