/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mcssp.integration.mccms;

import com.bxm.mccms.facade.model.sysdict.SysDictFacadeVO;
import com.bxm.mccms.facade.service.ISysDictFacadeService;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
@EnableFeignClients(value={"com.bxm.mccms.facade"})
public class SysDictIntegration {
    private static final Logger log = LoggerFactory.getLogger(SysDictIntegration.class);
    @Autowired
    private ISysDictFacadeService sysDictFacadeService;

    public List<SysDictFacadeVO> list(String typeCode, String parentDictValue) {
        ResponseEntity responseEntity = this.sysDictFacadeService.list(typeCode, parentDictValue);
        if (HttpStatus.OK.equals((Object)responseEntity.getStatusCode())) {
            return (List)responseEntity.getBody();
        }
        log.error("\u8fd0\u8425\u540e\u53f0\u5f02\u5e38\uff0c\u67e5\u8be2\u7cfb\u7edf\u5b57\u5178\u5217\u8868\u5931\u8d25\uff01-->{}", (Object)responseEntity.getStatusCodeValue());
        return Collections.emptyList();
    }

    public Map<String, String> getSysDictByTypeCode(String typeCode) {
        List<SysDictFacadeVO> list = this.list(typeCode, "");
        if (CollectionUtils.isNotEmpty(list)) {
            Map map = list.stream().collect(HashMap::new, (k, v) -> k.put(v.getDictValue(), v.getDictName()), HashMap::putAll);
            return map;
        }
        return Collections.emptyMap();
    }
}

