package com.bxm.messager.facade.service;

import com.bxm.messager.facade.bo.PageBO;
import com.bxm.messager.facade.dto.MessageInfoDTO;
import com.bxm.messager.facade.dto.MessageListInfoDTO;
import com.bxm.messager.facade.enums.ChannelEnum;
import com.bxm.messager.facade.enums.MessageOperateEnum;
import com.bxm.messager.facade.vo.MessageInfoListVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 *
 * 提供消息展示列表接口；发送消息接口
 *
 *
 * @author pf.w
 * @date 2021/8/18 11:21
 **/
@FeignClient(name = "MESSAGER")
public interface MessageInfoServiceFacade {


    /**
     * 获取消息列表
     *
     * @param channelId 广告主 或者 媒体 渠道ID
     * @param channel  主体类型 1:广告主 | 0:媒体
     * @param readFlag 已读 未读     0：未读  1：已读
     * @param sender 发件人  0：系统消息  1：推送消息
     * @param channelName 主体渠道名称
     * @param pageNum 当前页
     * @param pageSize 一页条数
     * @return
     */
    @RequestMapping(value = "/facade/getMessageList",method = RequestMethod.GET,consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<PageBO<MessageInfoListVO>> messageList(@RequestParam(value = "channelId") Long channelId,
                                                          @RequestParam(value = "channel") Integer channel,
                                                          @RequestParam(value = "readFlag") Integer readFlag,
                                                          @RequestParam(value = "sender") Integer sender,
                                                          @RequestParam(value = "channelName") String channelName,
                                                          @RequestParam(value = "pageNum") Integer pageNum,
                                                          @RequestParam(value = "pageSize") Integer pageSize);


    /**
     *
     * 设置推送内部消息
     *
     * @param param 消息内容  注意看param备注信息 不要遗漏字段
     * @return true成功
     */
    @RequestMapping(value = "/facade/pushMessage",method = RequestMethod.POST,consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Boolean> pushMessage(@RequestBody MessageInfoDTO param);

    /**
     *
     * 消息操作接口  目前只有设置已读未读状态
     *
     * @param messageId 消息id
     * @param operateType 动作类型 1: 已读
     * @param channel 主体类型  1：广告主 | 0：媒体
     * @param subjectId  主体ID  广告主ID | 媒体 ID
     * @return true 成功
     */
    @RequestMapping(value = "/facade/messageOperate",method = RequestMethod.GET,consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Boolean> messageOperate(@RequestParam(value = "messageId") Long messageId,
                                           @RequestParam(value = "operateType") Integer operateType,
                                           @RequestParam(value ="channel") Integer channel,
                                           @RequestParam(value = "subjectId") Long subjectId);
}
