package com.bxm.monitor.util.commons;

import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

/**
 * @Author: 拉拉
 * @Date: 2018年9月03日 上午10:26:11
 */
@Component
public class RedisClientByCode {

    @Autowired
    @Qualifier("jedisPool")
    private JedisPool jedisPool;

    /**
     * 方法描述:获取对象
     *
     * @param key 键
     * @return
     * @throws Exception
     * @author leon 2017年5月3日 上午11:58:47
     */
    public String get(String key, Integer dbIndex) {

        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex);
            }
            return jedis.get(key);
        } finally {
            // 返还到连接池
            jedis.close();
        }
    }

    /**
     * 方法描述:设置对象
     *
     * @param key
     * @param value
     * @throws Exception
     * @author leon 2017年5月3日 上午11:58:35
     */
    public void set(String key, String value, Integer dbIndex) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex);
            }
            jedis.set(key, value);
        } finally {
            // 返还到连接池
            jedis.close();
        }
    }

    public void setWithTimeAndDB(String key, String value, Long seconds, Integer dbIndex) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex);
            }
            jedis.set(key, value);
            if (seconds != null) {
                jedis.expire(key, seconds.intValue());
            }
        } finally {
            jedis.close();
        }
    }

    /**
     * 方法描述:删除所有匹配给定的模式的键
     * 
     * @author leon 2017年7月18日 下午2:32:52
     * @param redisKey pattern 的表达式,*表示多个，？表示一个
     * @return
     */
    public void delByKeys(String redisKey, Integer dbIndex) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex);
            }
            Set<String> keys = jedis.keys(redisKey);
            if (keys != null && keys.size() > 0) {
                for (String key : keys) {
                    jedis.del(key);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            // 返还到连接池
            if (jedis != null) {
                jedis.close();
            }
        }
    }
}
