package com.bxm.newidea.component.impl;

import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.geoip.model.v20200101.DescribeGeoipInstanceDataInfosRequest;
import com.aliyuncs.geoip.model.v20200101.DescribeGeoipInstanceDataInfosResponse;
import com.aliyuncs.geoip.model.v20200101.DescribeGeoipInstanceDataUrlRequest;
import com.aliyuncs.geoip.model.v20200101.DescribeGeoipInstanceDataUrlResponse;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.config.AlibabaIpProperties;
import com.bxm.newidea.component.enums.DescribeTypeEnum;
import com.bxm.newidea.component.utils.IpAddrUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Objects;

/**
 * @author lowi
 * @date 2021/6/1 9:38
 */
@Service
@Slf4j
public class DescribeIpv4OnlineService {

    @Autowired
    AlibabaIpProperties alibabaIpProperties;


    public void updateIpData() {
        IAcsClient iAcsClient = IpAddrUtils.getIAcsClient();
        getIpDataVersion(iAcsClient);
    }

    private void getIpDataVersion(IAcsClient client) {
        //获取阿里云ip数据
        DescribeGeoipInstanceDataInfosRequest request = new DescribeGeoipInstanceDataInfosRequest();
        request.setInstanceId(alibabaIpProperties.getInstanceId());
        DescribeGeoipInstanceDataInfosResponse response = null;
        try {
            response = client.getAcsResponse(request);
            log.info("阿里云ip地址服务API返回数据：{}", JSON.toJSONString(response));
        } catch (ClientException e) {
            log.error("获取阿里云ip地址服务API失败", e);
            return;
        }
        //是否实例化链接
        boolean initClient = false;

        //获取实例的列表信息
        for (DescribeGeoipInstanceDataInfosResponse.DataInfo dataInfo : response.getDataInfos()) {

            if (Objects.equals(DescribeTypeEnum.LICENSE.name(), dataInfo.getType())) {
                //下载数据
                initClient = downloadIpData(client, dataInfo.getType(), "licenseFile.lic");
            }

            if (Objects.equals(DescribeTypeEnum.IPV4_DATA.name(), dataInfo.getType())) {
                //下载数据
                initClient = downloadIpData(client, dataInfo.getType(), "dataFile.dex");
            }
        }

        //如果ipv4数据或者授权证书版本号发生改变，则实例化链接
        if (initClient) {
            IpAddrUtils.initDefaultAcsClient();
        }
    }

    private boolean downloadIpData(IAcsClient client, String type, String fileName) {
        DescribeGeoipInstanceDataUrlRequest request = new DescribeGeoipInstanceDataUrlRequest();
        request.setInstanceId(alibabaIpProperties.getInstanceId());
        request.setDataType(type);
        DescribeGeoipInstanceDataUrlResponse response = null;
        try {
            response = client.getAcsResponse(request);
            log.info("阿里云ip地址服务API返回数据：{}", JSON.toJSONString(response));
        } catch (ClientException e) {
            log.error("获取阿里云ip地址服务API失败", e);
            return false;
        }
        try {
            download(response.getFixedDomainDownloadUrl(), alibabaIpProperties.getDownloadFilePath(), fileName);
        } catch (IOException e) {
            log.error("下载资源失败", e);
            return false;
        }
        return true;
    }


    /**
     * description: 使用url 下载远程文件
     *
     * @param urlPath         --- url资源
     * @param targetDirectory --- 目标文件夹
     * @return void
     * @throws Exception
     * @version v1.0
     * @author w
     * @date 2019年9月3日 下午8:29:01
     */
    private String download(String urlPath, String targetDirectory, String fileName) throws IOException {
        // 解决url中可能有中文情况
        URL url;
        HttpURLConnection http = null;
        OutputStream out = null;
        InputStream inputStream = null;
        try {
            url = new URL(urlPath);
            http = (HttpURLConnection) url.openConnection();
            http.setConnectTimeout(3000);
            // 设置 User-Agent 避免被拦截
            http.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 9.0; Windows NT 6.1; Trident/5.0)");
            // 获取文件名
            fileName = fileName == null ? getFileName(http, urlPath) : fileName;
            inputStream = http.getInputStream();
            byte[] buff = new byte[1024 * 10];
            File file = new File(targetDirectory);
            if (!file.exists()) {
                file.mkdirs();
            }
            out = new FileOutputStream(new File(targetDirectory, fileName));
            int len;
            while ((len = inputStream.read(buff)) != -1) {
                out.write(buff, 0, len);
                out.flush();
            }
        } catch (IOException e) {
            log.error("下载资源失败", e);
        } finally {
            // 关闭资源
            if (out != null) {
                out.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
            if (http != null) {
                http.disconnect();
            }
        }
        return targetDirectory + fileName;
    }

    /**
     * description: 获取文件名
     *
     * @param http
     * @param urlPath
     * @return String
     * @throws UnsupportedEncodingException
     * @version v1.0
     * @author w
     * @date 2019年9月3日 下午8:25:55
     */
    private String getFileName(HttpURLConnection http, String urlPath) throws UnsupportedEncodingException {
        String headerField = http.getHeaderField("Content-Disposition");
        String fileName = null;
        if (null != headerField) {
            String decode = URLDecoder.decode(headerField, "UTF-8");
            fileName = decode.split(";")[1].split("=")[1].replaceAll("\"", "");
        }
        if (null == fileName) {
            // 尝试从url中获取文件名
            String[] arr = urlPath.split("/");
            fileName = arr[arr.length - 1];
        }
        return fileName;
    }

}
