package com.bxm.newidea.component.utils;

import com.alibaba.sec.client.FastIPGeoClient;
import com.alibaba.sec.domain.FastGeoConf;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.profile.DefaultProfile;
import com.bxm.newidea.component.config.AlibabaIpProperties;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.Arrays;
import java.util.HashSet;


/**
 * @author lowi
 * @date 2021/5/28 18:12
 */
@Component
@Slf4j
public class IpAddrUtils {

    private static FastIPGeoClient fastIPGeoClient = null;

    private static IAcsClient iAcsClient = null;

    private static AlibabaIpProperties alibabaIpProperties;

    @Autowired
    private AlibabaIpProperties properties;

    @PostConstruct
    public void init() {
        alibabaIpProperties = properties;
    }

    /**
     * 初始化链接
     *
     * @return FastIPGeoClient 离线api的链接
     */
    public static FastIPGeoClient initDefaultAcsClient() {
        FastGeoConf geoConf = new FastGeoConf();
        geoConf.setLicenseFilePath(alibabaIpProperties.getLicenseFilePath());
        geoConf.setDataFilePath(alibabaIpProperties.getDataFilePath());
        HashSet<String> set = new HashSet<>(Arrays.asList(
                "country", "province", "province_code",
                "city", "city_code", "county", "county_code",
                "isp", "isp_code", "routes",
                "longitude", "latitude"
        ));
        geoConf.setProperties(set);
        geoConf.filterEmptyValue();
        try {
            fastIPGeoClient = FastIPGeoClient.getSingleton(geoConf);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return fastIPGeoClient;
    }

    /**
     * 获取链接
     *
     * @return FastIPGeoClient 离线api的链接
     */
    public static FastIPGeoClient getDefaultAcsClient() {

        if (fastIPGeoClient == null) {
            FastGeoConf geoConf = new FastGeoConf();
            geoConf.setLicenseFilePath(alibabaIpProperties.getLicenseFilePath());
            geoConf.setDataFilePath(alibabaIpProperties.getDataFilePath());
            HashSet<String> set = new HashSet<>(Arrays.asList(
                    "country", "province", "province_code",
                    "city", "city_code", "county", "county_code",
                    "isp", "isp_code", "routes",
                    "longitude", "latitude","ip","country_code"
            ));
            geoConf.setProperties(set);
            geoConf.filterEmptyValue();

            try {
                fastIPGeoClient = FastIPGeoClient.getSingleton(geoConf);
            } catch (Exception e) {
                e.printStackTrace();
            }
            return fastIPGeoClient;
        }
        return fastIPGeoClient;
    }

    public static IAcsClient getIAcsClient() {
        if (iAcsClient == null) {
            DefaultProfile profile = DefaultProfile.getProfile(
                    alibabaIpProperties.getRegionId(),
                    alibabaIpProperties.getAccessKeyId(),
                    alibabaIpProperties.getSecret()
            );
            iAcsClient = new DefaultAcsClient(profile);
        }
        return iAcsClient;
    }

}
