/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.utils;

import com.alibaba.sec.client.FastIPGeoClient;
import com.alibaba.sec.domain.FastGeoConf;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.bxm.newidea.component.config.AlibabaIpProperties;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IpAddrUtils {
    private static final Logger log = LoggerFactory.getLogger(IpAddrUtils.class);
    public static String TEMP_FILE_LICENSE_FILE_PATH = null;
    public static String TEMP_FILE_DATA_FILE_PATH = null;
    private static FastIPGeoClient fastIPGeoClient = null;
    private static IAcsClient iAcsClient = null;
    private static AlibabaIpProperties alibabaIpProperties;
    @Autowired
    private AlibabaIpProperties properties;

    @PostConstruct
    public void init() {
        alibabaIpProperties = this.properties;
    }

    public static FastIPGeoClient initDefaultAcsClient() {
        FastGeoConf geoConf = new FastGeoConf();
        geoConf.setLicenseFilePath(TEMP_FILE_LICENSE_FILE_PATH);
        geoConf.setDataFilePath(TEMP_FILE_DATA_FILE_PATH);
        HashSet<String> set = new HashSet<String>(Arrays.asList("country", "province", "province_code", "city", "city_code", "county", "county_code", "isp", "isp_code", "routes", "longitude", "latitude"));
        geoConf.setProperties(set);
        geoConf.filterEmptyValue();
        try {
            fastIPGeoClient = FastIPGeoClient.getSingleton((FastGeoConf)geoConf);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return fastIPGeoClient;
    }

    public static FastIPGeoClient getDefaultAcsClient() {
        if (fastIPGeoClient == null) {
            FastGeoConf geoConf = new FastGeoConf();
            geoConf.setLicenseFilePath(TEMP_FILE_LICENSE_FILE_PATH);
            geoConf.setDataFilePath(TEMP_FILE_DATA_FILE_PATH);
            HashSet<String> set = new HashSet<String>(Arrays.asList("country", "province", "province_code", "city", "city_code", "county", "county_code", "isp", "isp_code", "routes", "longitude", "latitude", "ip", "country_code"));
            geoConf.setProperties(set);
            geoConf.filterEmptyValue();
            try {
                fastIPGeoClient = FastIPGeoClient.getSingleton((FastGeoConf)geoConf);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            return fastIPGeoClient;
        }
        return fastIPGeoClient;
    }

    public static IAcsClient getIAcsClient() {
        if (iAcsClient == null) {
            DefaultProfile profile = DefaultProfile.getProfile((String)alibabaIpProperties.getRegionId(), (String)alibabaIpProperties.getAccessKeyId(), (String)alibabaIpProperties.getSecret());
            iAcsClient = new DefaultAcsClient((IClientProfile)profile);
        }
        return iAcsClient;
    }
}

