package com.bxm.newidea.component.impl;

import com.alibaba.sec.client.FastIPGeoClient;
import com.alibaba.sec.exception.FastIPGeoException;
import com.alibaba.sec.license.exception.LicenseException;
import com.bxm.newidea.component.IpAddrInterface;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.entity.IpAddrDetails;
import com.bxm.newidea.component.thread.NamedThreadFactory;
import com.bxm.newidea.component.utils.IpAddrUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

/**
 * @author lowi
 * @date 2021/5/28 18:09
 */
@Component
@Slf4j
public class DescribeIpOnlineService implements IpAddrInterface {

    @Override
    public IpAddrDetails getIpAddrInfo(String ip) {

        FastIPGeoClient defaultAcsClient = IpAddrUtils.getDefaultAcsClient();
        try {
            String search = defaultAcsClient.search(ip);
            return JSON.parseObject(search, IpAddrDetails.class);
        } catch (FastIPGeoException | LicenseException e) {
            log.error("阿里解析地址失败ip:{}", ip, e);
        }
        return null;
    }

}
