/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.impl;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.geoip.model.v20200101.DescribeGeoipInstanceDataInfosRequest;
import com.aliyuncs.geoip.model.v20200101.DescribeGeoipInstanceDataInfosResponse;
import com.aliyuncs.geoip.model.v20200101.DescribeGeoipInstanceDataUrlRequest;
import com.aliyuncs.geoip.model.v20200101.DescribeGeoipInstanceDataUrlResponse;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.config.AlibabaIpProperties;
import com.bxm.newidea.component.enums.DescribeTypeEnum;
import com.bxm.newidea.component.utils.IpAddrUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DescribeIpv4OnlineService {
    private static final Logger log = LoggerFactory.getLogger(DescribeIpv4OnlineService.class);
    @Resource
    private AlibabaIpProperties alibabaIpProperties;

    public void updateIpData() {
        IAcsClient iAcsClient = IpAddrUtils.getIAcsClient();
        this.getIpDataVersion(iAcsClient);
    }

    private void getIpDataVersion(IAcsClient client) {
        DescribeGeoipInstanceDataInfosResponse response;
        DescribeGeoipInstanceDataInfosRequest request = new DescribeGeoipInstanceDataInfosRequest();
        request.setInstanceId(this.alibabaIpProperties.getInstanceId());
        try {
            response = (DescribeGeoipInstanceDataInfosResponse)client.getAcsResponse((AcsRequest)request);
            log.info("\u963f\u91cc\u4e91ip\u5730\u5740\u670d\u52a1API\u8fd4\u56de\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)response));
        }
        catch (ClientException e) {
            log.error("\u83b7\u53d6\u963f\u91cc\u4e91ip\u5730\u5740\u670d\u52a1API\u5931\u8d25", (Throwable)e);
            return;
        }
        boolean initClient = false;
        for (DescribeGeoipInstanceDataInfosResponse.DataInfo dataInfo : response.getDataInfos()) {
            if (Objects.equals(DescribeTypeEnum.LICENSE.name(), dataInfo.getType())) {
                initClient = this.downloadIpData(client, dataInfo.getType(), "licenseFile.lic", DescribeTypeEnum.LICENSE);
            }
            if (!Objects.equals(DescribeTypeEnum.IPV4_DATA.name(), dataInfo.getType())) continue;
            initClient = this.downloadIpData(client, dataInfo.getType(), "dataFile.dex", DescribeTypeEnum.IPV4_DATA);
        }
        if (initClient) {
            IpAddrUtils.initDefaultAcsClient();
        }
    }

    private boolean downloadIpData(IAcsClient client, String type, String fileName, DescribeTypeEnum describeTypeEnum) {
        DescribeGeoipInstanceDataUrlResponse response;
        DescribeGeoipInstanceDataUrlRequest request = new DescribeGeoipInstanceDataUrlRequest();
        request.setInstanceId(this.alibabaIpProperties.getInstanceId());
        request.setDataType(type);
        try {
            response = (DescribeGeoipInstanceDataUrlResponse)client.getAcsResponse((AcsRequest)request);
            log.info("\u963f\u91cc\u4e91ip\u5730\u5740\u670d\u52a1API\u8fd4\u56de\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)response));
        }
        catch (ClientException e) {
            log.error("\u83b7\u53d6\u963f\u91cc\u4e91ip\u5730\u5740\u670d\u52a1API\u5931\u8d25", (Throwable)e);
            return false;
        }
        try {
            this.download(response.getFixedDomainDownloadUrl(), fileName, describeTypeEnum);
        }
        catch (IOException e) {
            log.error("\u4e0b\u8f7d\u8d44\u6e90\u5931\u8d25", (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(String urlPath, String fileName, DescribeTypeEnum describeTypeEnum) throws IOException {
        HttpURLConnection http = null;
        OutputStream out = null;
        InputStream inputStream = null;
        try {
            int len;
            URL url = new URL(urlPath);
            http = (HttpURLConnection)url.openConnection();
            http.setConnectTimeout(3000);
            http.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 9.0; Windows NT 6.1; Trident/5.0)");
            fileName = fileName == null ? this.getFileName(http, urlPath) : fileName;
            inputStream = http.getInputStream();
            byte[] buff = new byte[10240];
            File sysTempDir = new File(System.getProperty("java.io.tmpdir"));
            String targetDirectory = sysTempDir.getCanonicalPath();
            if (Objects.equals((Object)DescribeTypeEnum.LICENSE, (Object)describeTypeEnum)) {
                IpAddrUtils.TEMP_FILE_LICENSE_FILE_PATH = sysTempDir.getCanonicalPath() + "/" + fileName;
            } else {
                IpAddrUtils.TEMP_FILE_DATA_FILE_PATH = sysTempDir.getCanonicalPath() + "/" + fileName;
            }
            out = new FileOutputStream(new File(targetDirectory, fileName));
            while ((len = inputStream.read(buff)) != -1) {
                out.write(buff, 0, len);
                out.flush();
            }
        }
        catch (IOException e) {
            log.error("\u4e0b\u8f7d\u8d44\u6e90\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
            if (http != null) {
                http.disconnect();
            }
        }
    }

    private String getFileName(HttpURLConnection http, String urlPath) throws UnsupportedEncodingException {
        String headerField = http.getHeaderField("Content-Disposition");
        String fileName = null;
        if (null != headerField) {
            String decode = URLDecoder.decode(headerField, "UTF-8");
            fileName = decode.split(";")[1].split("=")[1].replaceAll("\"", "");
        }
        if (null == fileName) {
            String[] arr = urlPath.split("/");
            fileName = arr[arr.length - 1];
        }
        return fileName;
    }

    public void downloadOssConfigFile() {
        try {
            this.download(this.alibabaIpProperties.getDataFileUrl(), "dataFile.dex", DescribeTypeEnum.IPV4_DATA);
            this.download(this.alibabaIpProperties.getLicenseFileUrl(), "licenseFile.lic", DescribeTypeEnum.LICENSE);
        }
        catch (IOException e) {
            log.error("oss\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }
}

