/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.apollo.i18n;

import com.bxm.newidea.component.apollo.i18n.MessageHelper;
import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.ctrip.framework.apollo.spring.config.ConfigPropertySource;
import com.ctrip.framework.apollo.spring.config.ConfigPropertySourceFactory;
import com.ctrip.framework.apollo.spring.util.SpringInjector;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.AbstractMessageSource;

public class ApolloMessageSource
extends AbstractMessageSource {
    private static final Logger log = LoggerFactory.getLogger(ApolloMessageSource.class);
    private Locale defaultLocale = Locale.CHINA;
    private final ConfigPropertySourceFactory configPropertySourceFactory = (ConfigPropertySourceFactory)SpringInjector.getInstance(ConfigPropertySourceFactory.class);
    private static final String I18N_NAMESPACE_PREFIX = "i18N";
    private Map<Locale, Map<String, MessageFormat>> cacheMessages = Maps.newHashMap();

    public ApolloMessageSource() {
        MessageHelper.setMessageSource(this);
    }

    protected MessageFormat resolveCode(String code, Locale locale) {
        MessageFormat message;
        Map<Object, Object> cacheMap = this.cacheMessages.get(locale);
        if (null == cacheMap) {
            cacheMap = Maps.newHashMap();
            String loadNameSpace = "i18N." + this.getLocaleSpace(locale);
            Config config = ConfigService.getConfig((String)loadNameSpace);
            if (null != config) {
                String[] propertyNames;
                ConfigPropertySource configPropertySource = this.configPropertySourceFactory.getConfigPropertySource(loadNameSpace, config);
                configPropertySource.addChangeListener(changeEvent -> this.refresh(changeEvent, locale));
                for (String propertyName : propertyNames = configPropertySource.getPropertyNames()) {
                    String propertyValue = Objects.toString(configPropertySource.getProperty(propertyName));
                    cacheMap.put(propertyName, new MessageFormat(propertyValue, locale));
                }
            } else {
                log.error("\u8bf7\u6c42\u7684\u56fd\u9645\u5316\u914d\u7f6e\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4apollo\u662f\u5426\u914d\u7f6e\u4e86\u540d\u4e3a{}\u7684namespace", (Object)loadNameSpace);
            }
            this.cacheMessages.putIfAbsent(locale, cacheMap);
        }
        if (null != (message = (MessageFormat)cacheMap.get(code))) {
            return message;
        }
        cacheMap = this.cacheMessages.get(this.defaultLocale);
        if (null != cacheMap && null != (message = (MessageFormat)cacheMap.get(code))) {
            log.warn("\u7f16\u7801\uff1a{}\u672a\u5b9a\u4e49\uff0c\u4f7f\u7528\u9ed8\u8ba4\u7684locale", (Object)code, (Object)locale.toString());
            return message;
        }
        log.warn("\u7f16\u7801\uff1a{}\u672a\u5b9a\u4e49\uff0c\u9ed8\u8ba4locale\u4e2d\u4e5f\u672a\u5b9a\u4e49", (Object)code, (Object)locale.toString());
        return null;
    }

    private String getLocaleSpace(Locale locale) {
        return locale.getLanguage() + "_" + locale.getCountry();
    }

    private void refresh(ConfigChangeEvent changeEvent, Locale locale) {
        Map<String, MessageFormat> messageFormatMap = this.cacheMessages.get(locale);
        if (null != messageFormatMap) {
            changeEvent.changedKeys().forEach(key -> {
                log.info("\u8fdc\u7a0b\u6d88\u606f\u914d\u7f6e\u53d8\u66f4\uff0clocal:{},changKey:{},oldVlaue:{},newValue:{}", new Object[]{locale, key, changeEvent.getChange(key).getOldValue(), changeEvent.getChange(key).getNewValue()});
                messageFormatMap.put((String)key, new MessageFormat(changeEvent.getChange(key).getNewValue(), locale));
            });
        }
    }
}

