package com.bxm.newidea.component.apollo;

import com.bxm.newidea.component.apollo.i18n.ApolloMessageSource;
import com.ctrip.framework.apollo.model.ConfigChange;
import com.ctrip.framework.apollo.spring.boot.ApolloAutoConfiguration;
import com.ctrip.framework.apollo.spring.config.ConfigPropertySourceFactory;
import com.ctrip.framework.apollo.spring.util.SpringInjector;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;

/**
 * 自定义apollo相关的额外配置
 * @author liujia
 */
@Configuration
@Slf4j
@AutoConfigureAfter(ApolloAutoConfiguration.class)
public class CustomApolloAutoConfiguration {

    @Bean
    public ApolloMessageSource apolloMessageSource() {
        return new ApolloMessageSource();
    }

    /**
     * 因为@ConfigurationProperties的变更在默认的apollo-client中未实现注入，需要额外的监听器来处理
     * 给命名空间添加变更
     * @param event spring启动完成的事件
     */
    @EventListener(ApplicationStartedEvent.class)
    public void initNamespaceListener(ApplicationStartedEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();

        ConfigPropertySourceFactory configPropertySourceFactory
                = SpringInjector.getInstance(ConfigPropertySourceFactory.class);
        configPropertySourceFactory.getAllConfigPropertySources().forEach(config -> {
            config.addChangeListener(changeEvent -> {
                //记录变更日志
                for (String key : changeEvent.changedKeys()) {
                    ConfigChange change = changeEvent.getChange(key);
                    log.info("apollo config change,key:{},old value:{},new value:{}", key
                            , change.getOldValue()
                            , change.getNewValue());

                }

                applicationContext.publishEvent(new EnvironmentChangeEvent(changeEvent.changedKeys()));
            });
        });

    }
}
