package com.bxm.newidea.component.apollo.i18n;

import lombok.extern.slf4j.Slf4j;
import org.springframework.context.MessageSource;

import java.util.Locale;

/**
 * 消息辅助类，暂时没有多语言需求，简化参数和调用方式
 * @author liujia
 * @date 2019/11/26 21:24
 */
@Slf4j
public class MessageHelper {
    private static volatile Locale CURRENT = Locale.CHINA;

    private static MessageSource messageSource = new NonMessageSource();

    private MessageHelper() {
    }

    static void setMessageSource(ApolloMessageSource messageSource) {
        MessageHelper.messageSource = messageSource;
    }

    /**
     * 变更默认的地区信息(会进行全局变更)
     * @param locale 地区信息
     */
    public static synchronized void changeLocale(Locale locale) {
        CURRENT = locale;
    }

    /**
     * 获取配置的消息
     * @param code 消息编码
     * @return 转换结果
     */
    public static String getMessage(String code) {
        return messageSource.getMessage(code, null, CURRENT);
    }

    /**
     * 获取配置的消息
     * @param code 消息编码
     * @param args 配置消息中的占位符
     * @return 转换结果
     */
    public static String getMessage(String code, Object... args) {
        return messageSource.getMessage(code, args, CURRENT);
    }

    /**
     * 获取配置的消息
     * @param code       消息编码
     * @param defaultMsg 消息未配置时的默认消息
     * @return 转换结果
     */
    public static String getMessageWithDefault(String code, String defaultMsg) {
        return messageSource.getMessage(code, null, defaultMsg, CURRENT);
    }

    /**
     * 获取配置的消息
     * @param code       消息编码
     * @param defaultMsg 消息未配置时的默认消息
     * @param args       配置消息中的占位符
     * @return 转换结果
     */
    public static String getMessageWithDefault(String code, String defaultMsg, Object... args) {
        return messageSource.getMessage(code, args, defaultMsg, CURRENT);
    }
}
