/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.apollo.i18n;

import com.bxm.newidea.component.apollo.i18n.ApolloMessageSource;
import com.bxm.newidea.component.apollo.i18n.NonMessageSource;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;

public class MessageHelper {
    private static final Logger log = LoggerFactory.getLogger(MessageHelper.class);
    private static volatile Locale CURRENT = Locale.CHINA;
    private static MessageSource messageSource = new NonMessageSource();

    private MessageHelper() {
    }

    static void setMessageSource(ApolloMessageSource messageSource) {
        MessageHelper.messageSource = messageSource;
    }

    public static synchronized void changeLocale(Locale locale) {
        CURRENT = locale;
    }

    public static String getMessage(String code) {
        return messageSource.getMessage(code, null, CURRENT);
    }

    public static String getMessage(String code, Object ... args) {
        return messageSource.getMessage(code, args, CURRENT);
    }

    public static String getMessageWithDefault(String code, String defaultMsg) {
        return messageSource.getMessage(code, null, defaultMsg, CURRENT);
    }

    public static String getMessageWithDefault(String code, String defaultMsg, Object ... args) {
        return messageSource.getMessage(code, args, defaultMsg, CURRENT);
    }
}

