package com.bxm.newidea.component.apollo;

import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfigChangeListener;
import com.netflix.appinfo.EurekaInstanceConfig;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class ApolloConfiguration implements ApplicationContextAware {

    private ApplicationContext applicationContext;

    @Autowired(required = false)
    private EurekaInstanceConfig instance;

    private static final String EUREKA_METADATA_PRE_KEY = "eureka.instance.metadata-map.env";

    @ApolloConfigChangeListener(value = {"application", "LN.common", "LN.clientConfig"})

    public void changeHandler(ConfigChangeEvent configChangeEvent) {
        for (String key : configChangeEvent.changedKeys()) {
            if (EUREKA_METADATA_PRE_KEY.equals(key) && null != instance) {
                String newValue = configChangeEvent.getChange(EUREKA_METADATA_PRE_KEY).getNewValue();
                if (log.isDebugEnabled()) {
                    log.debug("change key : {}", key);

                    log.debug("更新instance.metadata：{}", newValue);

                }
                //如果更新了预发布键值
                instance.getMetadataMap().put(EUREKA_METADATA_PRE_KEY, newValue);
            }
        }

        this.applicationContext.publishEvent(new EnvironmentChangeEvent(configChangeEvent.changedKeys()));
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}
