/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.apollo.i18n;

import com.bxm.newidea.component.apollo.i18n.ApolloMessageSource;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageHelper {
    private static final Logger log = LoggerFactory.getLogger(MessageHelper.class);
    private static Locale CURRENT = Locale.CHINA;
    private static ApolloMessageSource messageSource;

    private MessageHelper() {
    }

    static void setMessageSource(ApolloMessageSource messageSource) {
        MessageHelper.messageSource = messageSource;
    }

    private static void preCheck() {
        if (null == messageSource) {
            log.error("\u8be5\u7c7b\u5fc5\u987b\u5728SpringContext\u4e2d\u8fd0\u884c");
        }
    }

    public static void changeLocale(Locale locale) {
        CURRENT = locale;
    }

    public static String getMessage(String code) {
        MessageHelper.preCheck();
        return messageSource.getMessage(code, null, CURRENT);
    }

    public static String getMessage(String code, Object ... args) {
        MessageHelper.preCheck();
        return messageSource.getMessage(code, args, CURRENT);
    }

    public static String getMessageWithDefault(String code, String defaultMsg) {
        MessageHelper.preCheck();
        return messageSource.getMessage(code, null, defaultMsg, CURRENT);
    }

    public static String getMessageWithDefault(String code, String defaultMsg, Object ... args) {
        MessageHelper.preCheck();
        return messageSource.getMessage(code, args, defaultMsg, CURRENT);
    }
}

