/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.param;

import com.bxm.newidea.component.config.BarCodeTypeEnum;
import com.bxm.newidea.component.config.ImageTypeEnum;
import com.bxm.newidea.component.tools.FileUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.lang.StringUtils;
import org.krysalis.barcode4j.HumanReadablePlacement;

public class BarCodeParam {
    private int DEFAULT_MAX_LENGTH = 12800;
    private String message;
    private String barCodeImagePath;
    private OutputStream barCodeOutputStream;
    private BarCodeTypeEnum barCodeTypeEnum;
    private ImageTypeEnum barCodeImageType;
    private double width;
    private int height;
    private HumanReadablePlacement position;

    public BarCodeParam(String barCodeImagePath, String message) throws IOException {
        if (StringUtils.isEmpty((String)barCodeImagePath)) {
            throw new IllegalArgumentException("\u6761\u5f62\u7801\u5b58\u653e\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!FileUtils.checkAndCreateFile((String)barCodeImagePath)) {
            throw new IOException("\u521b\u5efa\u6587\u4ef6\u5939\u8def\u5f84\u4e0b\u6587\u4ef6\u5931\u8d25");
        }
        if (StringUtils.isEmpty((String)message) || message.length() > this.DEFAULT_MAX_LENGTH) {
            throw new IllegalArgumentException("\u6761\u5f62\u7801\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8d85\u8fc7\u6700\u5927\u503c");
        }
        FileOutputStream outputStream = new FileOutputStream(barCodeImagePath);
        this.barCodeImagePath = barCodeImagePath;
        this.initBean(outputStream, message);
    }

    public BarCodeParam(OutputStream outputStream, String message) {
        if (outputStream == null) {
            throw new IllegalArgumentException("\u8f93\u51fa\u6d41\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)message) || message.length() > this.DEFAULT_MAX_LENGTH) {
            throw new IllegalArgumentException("\u6761\u5f62\u7801\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8d85\u8fc7\u6700\u5927\u503c");
        }
        this.initBean(outputStream, message);
    }

    private void initBean(OutputStream outputStream, String message) {
        this.width = 2.0;
        this.height = 10;
        this.barCodeImageType = ImageTypeEnum.PNG;
        this.position = HumanReadablePlacement.HRP_BOTTOM;
        this.barCodeTypeEnum = BarCodeTypeEnum.BARCODE128;
        this.message = message;
        this.barCodeOutputStream = outputStream;
    }

    public String getMessage() {
        return this.message;
    }

    public String getBarCodeImagePath() {
        return this.barCodeImagePath;
    }

    public OutputStream getBarCodeOutputStream() {
        return this.barCodeOutputStream;
    }

    public BarCodeTypeEnum getBarCodeTypeEnum() {
        return this.barCodeTypeEnum;
    }

    public void setBarCodeTypeEnum(BarCodeTypeEnum barCodeTypeEnum) {
        if (BarCodeTypeEnum.EAN.equals((Object)barCodeTypeEnum)) {
            if (this.message.length() < 7 || this.message.length() > 8) {
                throw new IllegalArgumentException("EAN\u7801\u5185\u5bb9\u957f\u5ea6\u5fc5\u987b7-8\u4e2a\u5b57\u7b26");
            }
        } else if (BarCodeTypeEnum.UPCA.equals((Object)barCodeTypeEnum) && (this.message.length() < 11 || this.message.length() > 13)) {
            throw new IllegalArgumentException("UCP\u7801\u5185\u5bb9\u957f\u5ea6\u5fc5\u987b11-12\u4e2a\u5b57\u7b26");
        }
        this.barCodeTypeEnum = barCodeTypeEnum;
    }

    public ImageTypeEnum getBarCodeImageType() {
        return this.barCodeImageType;
    }

    public void setBarCodeImageType(ImageTypeEnum barCodeImageType) {
        this.barCodeImageType = barCodeImageType;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public HumanReadablePlacement getPosition() {
        return this.position;
    }

    public void setPosition(HumanReadablePlacement position) {
        this.position = position;
    }
}

